/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.OperatorUsingSecureRandom;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.jcajce.provider.ProvSecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Utils {
    static Map<String, DigestAlgorithm> digestNameToAlgMap = new HashMap<String, DigestAlgorithm>();
    static Map<DigestAlgorithm, DigestAlgorithm> hmacToAlgMap = new HashMap<DigestAlgorithm, DigestAlgorithm>();

    Utils() {
    }

    static boolean isAuthMode(Algorithm algorithm) {
        String string = algorithm.getName();
        return string.contains("/CCM") || string.contains("/EAX") || string.contains("/GCM") || string.contains("/CFB8MAC") || string.contains("/OCB") || string.contains("/GMAC") || string.contains("/CMAC") || string.contains("/CBCMAC") || string.contains("/MAC");
    }

    static String getBaseName(Algorithm algorithm) {
        String string = algorithm.getName();
        int n = string.indexOf(47);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (string.equals("TripleDES")) {
            return "DESede";
        }
        return string;
    }

    static boolean isNotNull(ASN1Encodable aSN1Encodable) {
        return aSN1Encodable != null && !DERNull.INSTANCE.equals(aSN1Encodable.toASN1Primitive());
    }

    static <T> T addRandomIfNeeded(T t, SecureRandom secureRandom) {
        if (t instanceof OperatorUsingSecureRandom) {
            return ((OperatorUsingSecureRandom)t).withSecureRandom(secureRandom);
        }
        return t;
    }

    static byte[] getKeyEncoding(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("no encoding for key");
        }
        return byArray;
    }

    static Set<Algorithm> getActiveSet(Algorithm[] algorithmArray) {
        LinkedHashSet<Algorithm> linkedHashSet = new LinkedHashSet<Algorithm>();
        for (Algorithm algorithm : algorithmArray) {
            if (!(algorithm instanceof FipsAlgorithm)) continue;
            linkedHashSet.add(algorithm);
        }
        return linkedHashSet;
    }

    static SymmetricKey convertKey(Algorithm algorithm, Key key) throws InvalidKeyException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key needs to be SecretKey.");
        }
        if (key instanceof ProvSecretKeySpec) {
            return ((ProvSecretKeySpec)key).getBaseKey();
        }
        return new SymmetricSecretKey(algorithm, key.getEncoded());
    }

    static DigestAlgorithm getUnderlyingDigestAlgorithm(Algorithm algorithm) {
        DigestAlgorithm digestAlgorithm = hmacToAlgMap.get(algorithm);
        if (digestAlgorithm != null) {
            return digestAlgorithm;
        }
        throw new IllegalStateException("HMAC algorithm not recognized: " + algorithm.getName());
    }

    static boolean keyNotLength(final SymmetricKey symmetricKey, int n) {
        byte[] byArray = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                return symmetricKey.getKeyBytes();
            }
        });
        return byArray.length != (n + 7) / 8;
    }

    static char[] extractPassword(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException {
        KeyStore.ProtectionParameter protectionParameter = loadStoreParameter.getProtectionParameter();
        if (protectionParameter == null) {
            return null;
        }
        if (protectionParameter instanceof KeyStore.PasswordProtection) {
            return ((KeyStore.PasswordProtection)protectionParameter).getPassword();
        }
        if (protectionParameter instanceof KeyStore.CallbackHandlerProtection) {
            CallbackHandler callbackHandler = ((KeyStore.CallbackHandlerProtection)protectionParameter).getCallbackHandler();
            PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
            try {
                callbackHandler.handle(new Callback[]{passwordCallback});
                return passwordCallback.getPassword();
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new IllegalArgumentException("PasswordCallback not recognised: " + unsupportedCallbackException.getMessage(), unsupportedCallbackException);
            }
        }
        throw new IllegalArgumentException("no support for protection parameter of type " + protectionParameter.getClass().getName());
    }

    static {
        digestNameToAlgMap.put("SHA-1", FipsSHS.Algorithm.SHA1);
        digestNameToAlgMap.put("SHA-224", FipsSHS.Algorithm.SHA224);
        digestNameToAlgMap.put("SHA-256", FipsSHS.Algorithm.SHA256);
        digestNameToAlgMap.put("SHA-384", FipsSHS.Algorithm.SHA384);
        digestNameToAlgMap.put("SHA-512", FipsSHS.Algorithm.SHA512);
        digestNameToAlgMap.put("SHA3-224", FipsSHS.Algorithm.SHA3_224);
        digestNameToAlgMap.put("SHA3-256", FipsSHS.Algorithm.SHA3_256);
        digestNameToAlgMap.put("SHA3-384", FipsSHS.Algorithm.SHA3_384);
        digestNameToAlgMap.put("SHA3-512", FipsSHS.Algorithm.SHA3_512);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA1_HMAC, FipsSHS.Algorithm.SHA1);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA224_HMAC, FipsSHS.Algorithm.SHA224);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA256_HMAC, FipsSHS.Algorithm.SHA256);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA384_HMAC, FipsSHS.Algorithm.SHA384);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA512_HMAC, FipsSHS.Algorithm.SHA512);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA512_224_HMAC, FipsSHS.Algorithm.SHA512_224);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA512_256_HMAC, FipsSHS.Algorithm.SHA512_256);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA3_224_HMAC, FipsSHS.Algorithm.SHA3_224);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA3_256_HMAC, FipsSHS.Algorithm.SHA3_256);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA3_384_HMAC, FipsSHS.Algorithm.SHA3_384);
        hmacToAlgMap.put(FipsSHS.Algorithm.SHA3_512_HMAC, FipsSHS.Algorithm.SHA3_512);
        hmacToAlgMap.put(SecureHash.Algorithm.MD5_HMAC, SecureHash.Algorithm.MD5);
        hmacToAlgMap.put(SecureHash.Algorithm.GOST3411_HMAC, SecureHash.Algorithm.GOST3411);
        hmacToAlgMap.put(SecureHash.Algorithm.RIPEMD128_HMAC, SecureHash.Algorithm.RIPEMD128);
        hmacToAlgMap.put(SecureHash.Algorithm.RIPEMD160_HMAC, SecureHash.Algorithm.RIPEMD160);
        hmacToAlgMap.put(SecureHash.Algorithm.RIPEMD256_HMAC, SecureHash.Algorithm.RIPEMD256);
        hmacToAlgMap.put(SecureHash.Algorithm.RIPEMD320_HMAC, SecureHash.Algorithm.RIPEMD320);
        hmacToAlgMap.put(SecureHash.Algorithm.WHIRLPOOL_HMAC, SecureHash.Algorithm.WHIRLPOOL);
        hmacToAlgMap.put(SecureHash.Algorithm.TIGER_HMAC, SecureHash.Algorithm.TIGER);
    }
}

