/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.index.sai.IndexValidation;
import org.apache.cassandra.index.sai.SSTableContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.view.View;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexViewManager {
    private static final Logger logger = LoggerFactory.getLogger(IndexViewManager.class);
    private final StorageAttachedIndex index;
    private final AtomicReference<View> view = new AtomicReference();

    public IndexViewManager(StorageAttachedIndex index) {
        this.index = index;
        this.view.set(new View(index.termType(), Collections.emptySet()));
    }

    public View view() {
        return this.view.get();
    }

    public Collection<SSTableContext> update(Collection<SSTableReader> oldSSTables, Collection<SSTableContext> newSSTableContexts, IndexValidation validation) {
        View newView;
        View currentView;
        Pair<Collection<SSTableIndex>, Collection<SSTableContext>> indexes = this.getBuiltIndexes(newSSTableContexts, validation);
        HashSet<SSTableIndex> newViewIndexes = new HashSet<SSTableIndex>();
        ArrayList<SSTableIndex> releasableIndexes = new ArrayList<SSTableIndex>();
        do {
            currentView = this.view.get();
            newViewIndexes.clear();
            releasableIndexes.clear();
            for (SSTableIndex sstableIndex : currentView) {
                SSTableReader sstable = sstableIndex.getSSTable();
                if (oldSSTables.contains(sstable) || newViewIndexes.contains(sstableIndex)) {
                    releasableIndexes.add(sstableIndex);
                    continue;
                }
                newViewIndexes.add(sstableIndex);
            }
            for (SSTableIndex sstableIndex : (Collection)indexes.left) {
                if (newViewIndexes.contains(sstableIndex)) {
                    releasableIndexes.add(sstableIndex);
                    continue;
                }
                newViewIndexes.add(sstableIndex);
            }
        } while (!this.view.compareAndSet(currentView, newView = new View(this.index.termType(), newViewIndexes)));
        releasableIndexes.forEach(SSTableIndex::release);
        if (logger.isTraceEnabled()) {
            logger.trace(this.index.identifier().logMessage("There are now {} active SSTable indexes."), (Object)this.view.get().getIndexes().size());
        }
        return (Collection)indexes.right;
    }

    public void drop(Collection<SSTableReader> sstablesToRebuild) {
        View currentView = this.view.get();
        HashSet<SSTableReader> toRemove = new HashSet<SSTableReader>(sstablesToRebuild);
        for (SSTableIndex index : currentView) {
            SSTableReader sstable = index.getSSTable();
            if (!toRemove.contains(sstable)) continue;
            index.markObsolete();
        }
        this.update(toRemove, Collections.emptyList(), IndexValidation.NONE);
    }

    public void invalidate() {
        View previousView = this.view.getAndSet(new View(this.index.termType(), Collections.emptyList()));
        for (SSTableIndex index : previousView) {
            index.markObsolete();
        }
    }

    private Pair<Collection<SSTableIndex>, Collection<SSTableContext>> getBuiltIndexes(Collection<SSTableContext> sstableContexts, IndexValidation validation) {
        HashSet<SSTableIndex> valid = new HashSet<SSTableIndex>(sstableContexts.size());
        HashSet<SSTableContext> invalid = new HashSet<SSTableContext>();
        for (SSTableContext sstableContext : sstableContexts) {
            if (sstableContext.sstable.isMarkedCompacted()) continue;
            if (!sstableContext.indexDescriptor.isPerColumnIndexBuildComplete(this.index.identifier())) {
                logger.debug(this.index.identifier().logMessage("An on-disk index build for SSTable {} has not completed."), (Object)sstableContext.descriptor());
                continue;
            }
            if (sstableContext.indexDescriptor.isIndexEmpty(this.index.termType(), this.index.identifier())) {
                logger.debug(this.index.identifier().logMessage("No on-disk index was built for SSTable {} because the SSTable had no indexable rows for the index."), (Object)sstableContext.descriptor());
                continue;
            }
            try {
                if (validation != IndexValidation.NONE && !sstableContext.indexDescriptor.validatePerIndexComponents(this.index.termType(), this.index.identifier(), validation, true, false)) {
                    invalid.add(sstableContext);
                    continue;
                }
                SSTableIndex ssTableIndex = sstableContext.newSSTableIndex(this.index);
                logger.debug(this.index.identifier().logMessage("Successfully created index for SSTable {}."), (Object)sstableContext.descriptor());
                if (valid.add(ssTableIndex)) continue;
                ssTableIndex.release();
            }
            catch (Throwable e) {
                logger.warn(this.index.identifier().logMessage("Failed to update per-column components for SSTable {}"), (Object)sstableContext.descriptor(), (Object)e);
                invalid.add(sstableContext);
            }
        }
        return Pair.create(valid, invalid);
    }
}

