/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.text.similarity.DamerauLevenshteinDistance;
import org.apache.commons.text.similarity.SimilarityInput;
import org.apache.commons.text.similarity.SimilarityInputTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class DamerauLevenshteinDistanceTest {
    private static DamerauLevenshteinDistance defaultInstance;

    @BeforeAll
    static void createInstance() {
        defaultInstance = new DamerauLevenshteinDistance();
    }

    static Stream<Arguments> limitedDamerauLevenshteinDistanceTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"", "test", 10, 4}), Arguments.of((Object[])new Object[]{"test", "", 10, 4}), Arguments.of((Object[])new Object[]{"", "test", 2, -1}), Arguments.of((Object[])new Object[]{"test", "", 2, -1}), Arguments.of((Object[])new Object[]{"testing long string", "testing", 2, -1}), Arguments.of((Object[])new Object[]{"kitten", "sitting", 1, -1}), Arguments.of((Object[])new Object[]{"saturday", "sunday", 3, 3}), Arguments.of((Object[])new Object[]{"hello", "world", 6, 4}), Arguments.of((Object[])new Object[]{"algorithm", "logarithm", 1, -1}), Arguments.of((Object[])new Object[]{"computer", "comptuer", 1, 1}), Arguments.of((Object[])new Object[]{"receive", "recieve", 3, 1}), Arguments.of((Object[])new Object[]{"programming", "porgramming", 0, -1}), Arguments.of((Object[])new Object[]{"test", "tset", 1, 1}), Arguments.of((Object[])new Object[]{"example", "exmaple", 3, 1}), Arguments.of((Object[])new Object[]{"transform", "transfrom", 0, -1}), Arguments.of((Object[])new Object[]{"information", "infromation", 1, 1}), Arguments.of((Object[])new Object[]{"development", "developemnt", 3, 1}), Arguments.of((Object[])new Object[]{"password", "passwrod", 0, -1}), Arguments.of((Object[])new Object[]{"separate", "seperate", 1, 1}), Arguments.of((Object[])new Object[]{"definitely", "definately", 3, 1}), Arguments.of((Object[])new Object[]{"occurrence", "occurence", 0, -1}), Arguments.of((Object[])new Object[]{"necessary", "neccessary", 1, 1}), Arguments.of((Object[])new Object[]{"restaurant", "restaraunt", 4, 2}), Arguments.of((Object[])new Object[]{"beginning", "begining", 0, -1}), Arguments.of((Object[])new Object[]{"government", "goverment", 1, 1}), Arguments.of((Object[])new Object[]{"abcdefghijklmnop", "ponmlkjihgfedcba", 17, 15}), Arguments.of((Object[])new Object[]{"AAAAAAAAAA", "BBBBBBBBBB", 5, -1}), Arguments.of((Object[])new Object[]{"abababababab", "babababababa", 2, 2}), Arguments.of((Object[])new Object[]{"supercalifragilisticexpialidocious", "supercalifragilisticexpialidocous", 3, 1}), Arguments.of((Object[])new Object[]{"pneumonoultramicroscopicsilicovolcanoconiosiss", "pneumonoultramicroscopicsilicovolcanoconiosis", 0, -1}), Arguments.of((Object[])new Object[]{"abcdefg", "gfedcba", 6, 6}), Arguments.of((Object[])new Object[]{"xyxyxyxyxy", "yxyxyxyxyx", 4, 2}), Arguments.of((Object[])new Object[]{"aaaaabbbbbccccc", "cccccbbbbbaaaaa", 5, -1}), Arguments.of((Object[])new Object[]{"thequickbrownfoxjumpsoverthelazydog", "thequickbrownfoxjumpsovrethelazydog", 1, 1}), Arguments.of((Object[])new Object[]{"antidisestablishmentarianism", "antidisestablishmentarianisn", 3, 1}));
    }

    static Stream<Arguments> limitedDamerauLevenshteinDistanceTestCases_SimilarityInput() {
        return SimilarityInputTest.similarityInputs().flatMap(cls -> DamerauLevenshteinDistanceTest.limitedDamerauLevenshteinDistanceTestCases().map(arguments -> {
            Object[] values = Arrays.copyOf(arguments.get(), arguments.get().length + 1);
            values[values.length - 1] = cls;
            return Arguments.of((Object[])values);
        }));
    }

    static Stream<Arguments> unlimitedDamerauLevenshteinDistanceTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"", "test", 4}), Arguments.of((Object[])new Object[]{"test", "", 4}), Arguments.of((Object[])new Object[]{"kitten", "sitting", 3}), Arguments.of((Object[])new Object[]{"saturday", "sunday", 3}), Arguments.of((Object[])new Object[]{"hello", "world", 4}), Arguments.of((Object[])new Object[]{"algorithm", "logarithm", 3}), Arguments.of((Object[])new Object[]{"computer", "comptuer", 1}), Arguments.of((Object[])new Object[]{"receive", "recieve", 1}), Arguments.of((Object[])new Object[]{"programming", "porgramming", 1}), Arguments.of((Object[])new Object[]{"test", "tset", 1}), Arguments.of((Object[])new Object[]{"example", "exmaple", 1}), Arguments.of((Object[])new Object[]{"transform", "transfrom", 1}), Arguments.of((Object[])new Object[]{"information", "infromation", 1}), Arguments.of((Object[])new Object[]{"development", "developemnt", 1}), Arguments.of((Object[])new Object[]{"password", "passwrod", 1}), Arguments.of((Object[])new Object[]{"separate", "seperate", 1}), Arguments.of((Object[])new Object[]{"definitely", "definately", 1}), Arguments.of((Object[])new Object[]{"occurrence", "occurence", 1}), Arguments.of((Object[])new Object[]{"necessary", "neccessary", 1}), Arguments.of((Object[])new Object[]{"restaurant", "restaraunt", 2}), Arguments.of((Object[])new Object[]{"beginning", "begining", 1}), Arguments.of((Object[])new Object[]{"government", "goverment", 1}), Arguments.of((Object[])new Object[]{"abcdefghijklmnop", "ponmlkjihgfedcba", 15}), Arguments.of((Object[])new Object[]{"AAAAAAAAAA", "BBBBBBBBBB", 10}), Arguments.of((Object[])new Object[]{"abababababab", "babababababa", 2}), Arguments.of((Object[])new Object[]{"supercalifragilisticexpialidocious", "supercalifragilisticexpialidocous", 1}), Arguments.of((Object[])new Object[]{"pneumonoultramicroscopicsilicovolcanoconiosiss", "pneumonoultramicroscopicsilicovolcanoconiosis", 1}), Arguments.of((Object[])new Object[]{"abcdefg", "gfedcba", 6}), Arguments.of((Object[])new Object[]{"xyxyxyxyxy", "yxyxyxyxyx", 2}), Arguments.of((Object[])new Object[]{"aaaaabbbbbccccc", "cccccbbbbbaaaaa", 10}), Arguments.of((Object[])new Object[]{"thequickbrownfoxjumpsoverthelazydog", "thequickbrownfoxjumpsovrethelazydog", 1}), Arguments.of((Object[])new Object[]{"antidisestablishmentarianism", "antidisestablishmentarianisn", 1}));
    }

    static Stream<Arguments> unlimitedDamerauLevenshteinDistanceTestCases_SimilarityInput() {
        return SimilarityInputTest.similarityInputs().flatMap(cls -> DamerauLevenshteinDistanceTest.unlimitedDamerauLevenshteinDistanceTestCases().map(arguments -> {
            Object[] values = Arrays.copyOf(arguments.get(), arguments.get().length + 1);
            values[values.length - 1] = cls;
            return Arguments.of((Object[])values);
        }));
    }

    @ParameterizedTest(name="DamerauLevenshteinDistance.unlimitedCompare(\"{0}\", \"{1}\") should return {2}")
    @MethodSource(value={"unlimitedDamerauLevenshteinDistanceTestCases"})
    void testCalculateDamerauLevenshteinDistance(String left, String right, int expectedDistance) {
        int leftRightDistance = defaultInstance.apply((CharSequence)left, (CharSequence)right);
        int rightLeftDistance = defaultInstance.apply((CharSequence)right, (CharSequence)left);
        Assertions.assertEquals((int)expectedDistance, (int)leftRightDistance);
        Assertions.assertEquals((int)expectedDistance, (int)rightLeftDistance);
    }

    @ParameterizedTest(name="DamerauLevenshteinDistance.limitedCompare(\"{0}\", \"{1}\") should return {2}")
    @MethodSource(value={"limitedDamerauLevenshteinDistanceTestCases"})
    void testCalculateDamerauLevenshteinDistance(String left, String right, int threshold, int expectedDistance) {
        DamerauLevenshteinDistance instance = new DamerauLevenshteinDistance(Integer.valueOf(threshold));
        int leftRightDistance = instance.apply((CharSequence)left, (CharSequence)right);
        int rightLeftDistance = instance.apply((CharSequence)right, (CharSequence)left);
        Assertions.assertEquals((int)expectedDistance, (int)leftRightDistance);
        Assertions.assertEquals((int)expectedDistance, (int)rightLeftDistance);
    }

    @ParameterizedTest(name="DamerauLevenshteinDistance.unlimitedCompare(\"{0}\", \"{1}\") should return {2} ({3})")
    @MethodSource(value={"unlimitedDamerauLevenshteinDistanceTestCases_SimilarityInput"})
    void testCalculateDamerauLevenshteinDistance_SimilarityInput(String left, String right, int expectedDistance, Class<?> cls) {
        SimilarityInput<Object> leftInput = SimilarityInputTest.build(cls, left);
        SimilarityInput<Object> rightInput = SimilarityInputTest.build(cls, right);
        int leftRightDistance = defaultInstance.apply(leftInput, rightInput);
        int rightLeftDistance = defaultInstance.apply(rightInput, leftInput);
        Assertions.assertEquals((int)expectedDistance, (int)leftRightDistance);
        Assertions.assertEquals((int)expectedDistance, (int)rightLeftDistance);
    }

    @ParameterizedTest(name="DamerauLevenshteinDistance.limitedCompare(\"{0}\", \"{1}\") should return {2}")
    @MethodSource(value={"limitedDamerauLevenshteinDistanceTestCases_SimilarityInput"})
    void testCalculateDamerauLevenshteinDistance_SimilarityInput(String left, String right, int threshold, int expectedDistance, Class<?> cls) {
        DamerauLevenshteinDistance instance = new DamerauLevenshteinDistance(Integer.valueOf(threshold));
        SimilarityInput<Object> leftInput = SimilarityInputTest.build(cls, left);
        SimilarityInput<Object> rightInput = SimilarityInputTest.build(cls, right);
        int leftRightDistance = instance.apply(leftInput, rightInput);
        int rightLeftDistance = instance.apply(rightInput, leftInput);
        Assertions.assertEquals((int)expectedDistance, (int)leftRightDistance);
        Assertions.assertEquals((int)expectedDistance, (int)rightLeftDistance);
    }

    @Test
    void testGetThresholdDirectlyAfterObjectInstantiation() {
        Assertions.assertNull((Object)defaultInstance.getThreshold());
    }

    @Test
    void testGetThresholdIsCorrect() {
        DamerauLevenshteinDistance distance = new DamerauLevenshteinDistance(Integer.valueOf(10));
        Assertions.assertEquals((int)10, (Integer)distance.getThreshold());
    }

    @Test
    void testInvalidThresholdThrows() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DamerauLevenshteinDistance(Integer.valueOf(-1)));
    }

    @Test
    void testNullInputsThrowLimited() {
        DamerauLevenshteinDistance instance = new DamerauLevenshteinDistance(Integer.valueOf(10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> instance.apply(null, (CharSequence)"test"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> instance.apply((CharSequence)"test", null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> instance.apply(null, SimilarityInput.input((CharSequence)"test")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> instance.apply(SimilarityInput.input((CharSequence)"test"), null));
    }

    @Test
    void testNullInputsThrowUnlimited() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> defaultInstance.apply(null, (CharSequence)"test"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> defaultInstance.apply((CharSequence)"test", null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> defaultInstance.apply(null, SimilarityInput.input((CharSequence)"test")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> defaultInstance.apply(SimilarityInput.input((CharSequence)"test"), null));
    }
}

