/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class CreateSharedQueueMessage
extends PacketImpl {
    protected SimpleString address;
    protected SimpleString queueName;
    protected SimpleString filterString;
    protected boolean durable;
    protected boolean requiresResponse;

    public CreateSharedQueueMessage(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean requiresResponse) {
        this();
        this.address = address;
        this.queueName = queueName;
        this.filterString = filterString;
        this.durable = durable;
        this.requiresResponse = requiresResponse;
    }

    public CreateSharedQueueMessage() {
        this(36);
    }

    public CreateSharedQueueMessage(byte packetType) {
        super(packetType);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", address=" + String.valueOf(this.address));
        sb.append(", queueName=" + String.valueOf(this.queueName));
        sb.append(", filterString=" + String.valueOf(this.filterString));
        sb.append(", durable=" + this.durable);
        sb.append(", requiresResponse=" + this.requiresResponse);
        return sb.toString();
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public SimpleString getQueueName() {
        return this.queueName;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    @Override
    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public void setAddress(SimpleString address) {
        this.address = address;
    }

    public void setQueueName(SimpleString queueName) {
        this.queueName = queueName;
    }

    public void setFilterString(SimpleString filterString) {
        this.filterString = filterString;
    }

    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.address);
        buffer.writeSimpleString(this.queueName);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeBoolean(this.durable);
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.address = buffer.readSimpleString();
        this.queueName = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        this.durable = buffer.readBoolean();
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.address, this.filterString, this.queueName, this.durable, this.requiresResponse);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateSharedQueueMessage)) {
            return false;
        }
        CreateSharedQueueMessage other = (CreateSharedQueueMessage)obj;
        return this.durable == other.durable && this.requiresResponse == other.requiresResponse && Objects.equals(this.address, other.address) && Objects.equals(this.filterString, other.filterString) && Objects.equals(this.queueName, other.queueName);
    }
}

