/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication.db.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.security.basic.BasicAuthCommonCacheConfig;
import org.apache.druid.security.basic.BasicAuthUtils;
import org.apache.druid.security.basic.authentication.BasicHTTPAuthenticator;
import org.apache.druid.security.basic.authentication.db.cache.BasicAuthenticatorCacheManager;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorUser;
import org.apache.druid.server.security.Authenticator;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Duration;

@ManageLifecycle
public class CoordinatorPollingBasicAuthenticatorCacheManager
implements BasicAuthenticatorCacheManager {
    private static final EmittingLogger LOG = new EmittingLogger(CoordinatorPollingBasicAuthenticatorCacheManager.class);
    private final ConcurrentHashMap<String, Map<String, BasicAuthenticatorUser>> cachedUserMaps;
    private final Set<String> authenticatorPrefixes;
    private final Injector injector;
    private final ObjectMapper objectMapper;
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final ServiceClient coordinatorClient;
    private final BasicAuthCommonCacheConfig commonCacheConfig;
    private final ScheduledExecutorService exec = Execs.scheduledSingleThreaded((String)"BasicAuthenticatorCacheManager-Exec--%d");

    @Inject
    public CoordinatorPollingBasicAuthenticatorCacheManager(Injector injector, BasicAuthCommonCacheConfig commonCacheConfig, @Smile ObjectMapper objectMapper, @Coordinator ServiceClient coordinatorClient) {
        this.injector = injector;
        this.commonCacheConfig = commonCacheConfig;
        this.objectMapper = objectMapper;
        this.cachedUserMaps = new ConcurrentHashMap();
        this.authenticatorPrefixes = new HashSet<String>();
        this.coordinatorClient = coordinatorClient;
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        LOG.info("Starting CoordinatorPollingBasicAuthenticatorCacheManager.", new Object[0]);
        try {
            this.initUserMaps();
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)new Duration(this.commonCacheConfig.getPollingPeriod()), (Duration)new Duration(this.commonCacheConfig.getPollingPeriod()), () -> {
                try {
                    long randomDelay = ThreadLocalRandom.current().nextLong(0L, this.commonCacheConfig.getMaxRandomDelay());
                    LOG.debug("Inserting cachedUserMaps random polling delay of [%s] ms", new Object[]{randomDelay});
                    Thread.sleep(randomDelay);
                    LOG.debug("Scheduled user cache poll is running", new Object[0]);
                    for (String authenticatorPrefix : this.authenticatorPrefixes) {
                        Map<String, BasicAuthenticatorUser> userMap = this.fetchUserMapFromCoordinator(authenticatorPrefix, false);
                        if (userMap == null) continue;
                        this.cachedUserMaps.put(authenticatorPrefix, userMap);
                    }
                    LOG.debug("Scheduled user cache poll is done", new Object[0]);
                }
                catch (InterruptedException e) {
                    LOG.noStackTrace().info((Throwable)e, "Interrupted while polling Coordinator for cachedUserMaps.", new Object[0]);
                }
                catch (Throwable t) {
                    LOG.makeAlert(t, "Error occurred while polling for cachedUserMaps.", new Object[0]).emit();
                }
            });
            this.lifecycleLock.started();
            LOG.info("Started CoordinatorPollingBasicAuthenticatorCacheManager.", new Object[0]);
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        LOG.info("CoordinatorPollingBasicAuthenticatorCacheManager is stopping.", new Object[0]);
        this.exec.shutdownNow();
        LOG.info("CoordinatorPollingBasicAuthenticatorCacheManager is stopped.", new Object[0]);
    }

    @Override
    public void handleAuthenticatorUserMapUpdate(String authenticatorPrefix, byte[] serializedUserMap) {
        LOG.debug("Received user cache update for authenticator [%s].", new Object[]{authenticatorPrefix});
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        try {
            this.cachedUserMaps.put(authenticatorPrefix, (Map)this.objectMapper.readValue(serializedUserMap, BasicAuthUtils.AUTHENTICATOR_USER_MAP_TYPE_REFERENCE));
            if (this.commonCacheConfig.getCacheDirectory() != null) {
                this.writeUserMapToDisk(authenticatorPrefix, serializedUserMap);
            }
        }
        catch (Exception e) {
            LOG.makeAlert((Throwable)e, "Could not deserialize user map received from coordinator.", new Object[0]).emit();
        }
    }

    @Override
    public Map<String, BasicAuthenticatorUser> getUserMap(String authenticatorPrefix) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        return this.cachedUserMaps.get(authenticatorPrefix);
    }

    @Nullable
    private Map<String, BasicAuthenticatorUser> fetchUserMapFromCoordinator(String prefix, boolean isInit) {
        try {
            return (Map)RetryUtils.retry(() -> this.tryFetchUserMapFromCoordinator(prefix), e -> !(e instanceof InterruptedException), (int)this.commonCacheConfig.getMaxSyncRetries());
        }
        catch (InterruptedException e2) {
            LOG.noStackTrace().info((Throwable)e2, "Interrupted while fetching user map for authenticator[%s].", new Object[]{prefix});
            return null;
        }
        catch (Exception e3) {
            LOG.makeAlert((Throwable)e3, "Encountered exception while fetching user map for authenticator[%s]", new Object[]{prefix}).emit();
            if (isInit && this.commonCacheConfig.getCacheDirectory() != null) {
                try {
                    LOG.info("Attempting to load user map snapshot from disk.", new Object[0]);
                    return this.loadUserMapFromDisk(prefix);
                }
                catch (Exception e2) {
                    e2.addSuppressed(e3);
                    LOG.makeAlert((Throwable)e2, "Encountered exception while loading user map snapshot for authenticator [%s]", new Object[]{prefix}).emit();
                }
            }
            return null;
        }
    }

    private String getUserMapFilename(String prefix) {
        return StringUtils.format((String)"%s.authenticator.cache", (Object[])new Object[]{prefix});
    }

    @Nullable
    private Map<String, BasicAuthenticatorUser> loadUserMapFromDisk(String prefix) throws IOException {
        File userMapFile = new File(this.commonCacheConfig.getCacheDirectory(), this.getUserMapFilename(prefix));
        if (!userMapFile.exists()) {
            return null;
        }
        return (Map)this.objectMapper.readValue(userMapFile, BasicAuthUtils.AUTHENTICATOR_USER_MAP_TYPE_REFERENCE);
    }

    private void writeUserMapToDisk(String prefix, byte[] userMapBytes) throws IOException {
        File cacheDir = new File(this.commonCacheConfig.getCacheDirectory());
        FileUtils.mkdirp((File)cacheDir);
        File userMapFile = new File(this.commonCacheConfig.getCacheDirectory(), this.getUserMapFilename(prefix));
        FileUtils.writeAtomically((File)userMapFile, out -> {
            out.write(userMapBytes);
            return null;
        });
    }

    private Map<String, BasicAuthenticatorUser> tryFetchUserMapFromCoordinator(String prefix) throws Exception {
        Map userMap = null;
        RequestBuilder req = new RequestBuilder(HttpMethod.GET, StringUtils.format((String)"/druid-ext/basic-security/authentication/db/%s/cachedSerializedUserMap", (Object[])new Object[]{prefix}));
        BytesFullResponseHolder responseHolder = (BytesFullResponseHolder)this.coordinatorClient.request(req, (HttpResponseHandler)new BytesFullResponseHandler());
        byte[] userMapBytes = responseHolder.getContent();
        if (ArrayUtils.isNotEmpty((byte[])userMapBytes)) {
            userMap = (Map)this.objectMapper.readValue(userMapBytes, BasicAuthUtils.AUTHENTICATOR_USER_MAP_TYPE_REFERENCE);
            if (userMap != null && this.commonCacheConfig.getCacheDirectory() != null) {
                this.writeUserMapToDisk(prefix, userMapBytes);
            }
        } else {
            LOG.debug("Empty cached serialized user map retrieved, authenticator - %s", new Object[]{prefix});
        }
        return userMap;
    }

    private void initUserMaps() {
        AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)this.injector.getInstance(AuthenticatorMapper.class);
        if (authenticatorMapper == null || authenticatorMapper.getAuthenticatorMap() == null) {
            return;
        }
        for (Map.Entry entry : authenticatorMapper.getAuthenticatorMap().entrySet()) {
            Authenticator authenticator = (Authenticator)entry.getValue();
            if (!(authenticator instanceof BasicHTTPAuthenticator)) continue;
            String authenticatorName = (String)entry.getKey();
            this.authenticatorPrefixes.add(authenticatorName);
            Map<String, BasicAuthenticatorUser> userMap = this.fetchUserMapFromCoordinator(authenticatorName, true);
            if (userMap == null) continue;
            this.cachedUserMaps.put(authenticatorName, userMap);
        }
    }
}

