/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1NodeSelectorBuilder;
import io.kubernetes.client.openapi.models.V1NodeSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha2AllocationResult;
import io.kubernetes.client.openapi.models.V1alpha2AllocationResultFluent;
import io.kubernetes.client.openapi.models.V1alpha2ResourceHandle;
import io.kubernetes.client.openapi.models.V1alpha2ResourceHandleBuilder;
import io.kubernetes.client.openapi.models.V1alpha2ResourceHandleFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha2AllocationResultFluentImpl<A extends V1alpha2AllocationResultFluent<A>>
extends BaseFluent<A>
implements V1alpha2AllocationResultFluent<A> {
    private V1NodeSelectorBuilder availableOnNodes;
    private ArrayList<V1alpha2ResourceHandleBuilder> resourceHandles;
    private Boolean shareable;

    public V1alpha2AllocationResultFluentImpl() {
    }

    public V1alpha2AllocationResultFluentImpl(V1alpha2AllocationResult instance) {
        if (instance != null) {
            this.withAvailableOnNodes(instance.getAvailableOnNodes());
            this.withResourceHandles(instance.getResourceHandles());
            this.withShareable(instance.getShareable());
        }
    }

    @Override
    @Deprecated
    public V1NodeSelector getAvailableOnNodes() {
        return this.availableOnNodes != null ? this.availableOnNodes.build() : null;
    }

    @Override
    public V1NodeSelector buildAvailableOnNodes() {
        return this.availableOnNodes != null ? this.availableOnNodes.build() : null;
    }

    @Override
    public A withAvailableOnNodes(V1NodeSelector availableOnNodes) {
        this._visitables.get("availableOnNodes").remove(this.availableOnNodes);
        if (availableOnNodes != null) {
            this.availableOnNodes = new V1NodeSelectorBuilder(availableOnNodes);
            this._visitables.get("availableOnNodes").add(this.availableOnNodes);
        } else {
            this.availableOnNodes = null;
            this._visitables.get("availableOnNodes").remove(this.availableOnNodes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAvailableOnNodes() {
        return this.availableOnNodes != null;
    }

    @Override
    public V1alpha2AllocationResultFluent.AvailableOnNodesNested<A> withNewAvailableOnNodes() {
        return new AvailableOnNodesNestedImpl();
    }

    @Override
    public V1alpha2AllocationResultFluent.AvailableOnNodesNested<A> withNewAvailableOnNodesLike(V1NodeSelector item) {
        return new AvailableOnNodesNestedImpl(item);
    }

    @Override
    public V1alpha2AllocationResultFluent.AvailableOnNodesNested<A> editAvailableOnNodes() {
        return this.withNewAvailableOnNodesLike(this.getAvailableOnNodes());
    }

    @Override
    public V1alpha2AllocationResultFluent.AvailableOnNodesNested<A> editOrNewAvailableOnNodes() {
        return this.withNewAvailableOnNodesLike(this.getAvailableOnNodes() != null ? this.getAvailableOnNodes() : new V1NodeSelectorBuilder().build());
    }

    @Override
    public V1alpha2AllocationResultFluent.AvailableOnNodesNested<A> editOrNewAvailableOnNodesLike(V1NodeSelector item) {
        return this.withNewAvailableOnNodesLike(this.getAvailableOnNodes() != null ? this.getAvailableOnNodes() : item);
    }

    @Override
    public A addToResourceHandles(int index, V1alpha2ResourceHandle item) {
        if (this.resourceHandles == null) {
            this.resourceHandles = new ArrayList();
        }
        V1alpha2ResourceHandleBuilder builder = new V1alpha2ResourceHandleBuilder(item);
        if (index < 0 || index >= this.resourceHandles.size()) {
            this._visitables.get("resourceHandles").add(builder);
            this.resourceHandles.add(builder);
        } else {
            this._visitables.get("resourceHandles").add(index, builder);
            this.resourceHandles.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToResourceHandles(int index, V1alpha2ResourceHandle item) {
        if (this.resourceHandles == null) {
            this.resourceHandles = new ArrayList();
        }
        V1alpha2ResourceHandleBuilder builder = new V1alpha2ResourceHandleBuilder(item);
        if (index < 0 || index >= this.resourceHandles.size()) {
            this._visitables.get("resourceHandles").add(builder);
            this.resourceHandles.add(builder);
        } else {
            this._visitables.get("resourceHandles").set(index, builder);
            this.resourceHandles.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResourceHandles(V1alpha2ResourceHandle ... items) {
        if (this.resourceHandles == null) {
            this.resourceHandles = new ArrayList();
        }
        for (V1alpha2ResourceHandle item : items) {
            V1alpha2ResourceHandleBuilder builder = new V1alpha2ResourceHandleBuilder(item);
            this._visitables.get("resourceHandles").add(builder);
            this.resourceHandles.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResourceHandles(Collection<V1alpha2ResourceHandle> items) {
        if (this.resourceHandles == null) {
            this.resourceHandles = new ArrayList();
        }
        for (V1alpha2ResourceHandle item : items) {
            V1alpha2ResourceHandleBuilder builder = new V1alpha2ResourceHandleBuilder(item);
            this._visitables.get("resourceHandles").add(builder);
            this.resourceHandles.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResourceHandles(V1alpha2ResourceHandle ... items) {
        for (V1alpha2ResourceHandle item : items) {
            V1alpha2ResourceHandleBuilder builder = new V1alpha2ResourceHandleBuilder(item);
            this._visitables.get("resourceHandles").remove(builder);
            if (this.resourceHandles == null) continue;
            this.resourceHandles.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResourceHandles(Collection<V1alpha2ResourceHandle> items) {
        for (V1alpha2ResourceHandle item : items) {
            V1alpha2ResourceHandleBuilder builder = new V1alpha2ResourceHandleBuilder(item);
            this._visitables.get("resourceHandles").remove(builder);
            if (this.resourceHandles == null) continue;
            this.resourceHandles.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResourceHandles(Predicate<V1alpha2ResourceHandleBuilder> predicate) {
        if (this.resourceHandles == null) {
            return (A)this;
        }
        Iterator<V1alpha2ResourceHandleBuilder> each = this.resourceHandles.iterator();
        Object visitables = this._visitables.get("resourceHandles");
        while (each.hasNext()) {
            V1alpha2ResourceHandleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1alpha2ResourceHandle> getResourceHandles() {
        return this.resourceHandles != null ? V1alpha2AllocationResultFluentImpl.build(this.resourceHandles) : null;
    }

    @Override
    public List<V1alpha2ResourceHandle> buildResourceHandles() {
        return this.resourceHandles != null ? V1alpha2AllocationResultFluentImpl.build(this.resourceHandles) : null;
    }

    @Override
    public V1alpha2ResourceHandle buildResourceHandle(int index) {
        return this.resourceHandles.get(index).build();
    }

    @Override
    public V1alpha2ResourceHandle buildFirstResourceHandle() {
        return this.resourceHandles.get(0).build();
    }

    @Override
    public V1alpha2ResourceHandle buildLastResourceHandle() {
        return this.resourceHandles.get(this.resourceHandles.size() - 1).build();
    }

    @Override
    public V1alpha2ResourceHandle buildMatchingResourceHandle(Predicate<V1alpha2ResourceHandleBuilder> predicate) {
        for (V1alpha2ResourceHandleBuilder item : this.resourceHandles) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResourceHandle(Predicate<V1alpha2ResourceHandleBuilder> predicate) {
        for (V1alpha2ResourceHandleBuilder item : this.resourceHandles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResourceHandles(List<V1alpha2ResourceHandle> resourceHandles) {
        if (this.resourceHandles != null) {
            this._visitables.get("resourceHandles").clear();
        }
        if (resourceHandles != null) {
            this.resourceHandles = new ArrayList();
            for (V1alpha2ResourceHandle item : resourceHandles) {
                this.addToResourceHandles(item);
            }
        } else {
            this.resourceHandles = null;
        }
        return (A)this;
    }

    @Override
    public A withResourceHandles(V1alpha2ResourceHandle ... resourceHandles) {
        if (this.resourceHandles != null) {
            this.resourceHandles.clear();
            this._visitables.remove("resourceHandles");
        }
        if (resourceHandles != null) {
            for (V1alpha2ResourceHandle item : resourceHandles) {
                this.addToResourceHandles(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceHandles() {
        return this.resourceHandles != null && !this.resourceHandles.isEmpty();
    }

    @Override
    public V1alpha2AllocationResultFluent.ResourceHandlesNested<A> addNewResourceHandle() {
        return new ResourceHandlesNestedImpl();
    }

    @Override
    public V1alpha2AllocationResultFluent.ResourceHandlesNested<A> addNewResourceHandleLike(V1alpha2ResourceHandle item) {
        return new ResourceHandlesNestedImpl(-1, item);
    }

    @Override
    public V1alpha2AllocationResultFluent.ResourceHandlesNested<A> setNewResourceHandleLike(int index, V1alpha2ResourceHandle item) {
        return new ResourceHandlesNestedImpl(index, item);
    }

    @Override
    public V1alpha2AllocationResultFluent.ResourceHandlesNested<A> editResourceHandle(int index) {
        if (this.resourceHandles.size() <= index) {
            throw new RuntimeException("Can't edit resourceHandles. Index exceeds size.");
        }
        return this.setNewResourceHandleLike(index, this.buildResourceHandle(index));
    }

    @Override
    public V1alpha2AllocationResultFluent.ResourceHandlesNested<A> editFirstResourceHandle() {
        if (this.resourceHandles.size() == 0) {
            throw new RuntimeException("Can't edit first resourceHandles. The list is empty.");
        }
        return this.setNewResourceHandleLike(0, this.buildResourceHandle(0));
    }

    @Override
    public V1alpha2AllocationResultFluent.ResourceHandlesNested<A> editLastResourceHandle() {
        int index = this.resourceHandles.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceHandles. The list is empty.");
        }
        return this.setNewResourceHandleLike(index, this.buildResourceHandle(index));
    }

    @Override
    public V1alpha2AllocationResultFluent.ResourceHandlesNested<A> editMatchingResourceHandle(Predicate<V1alpha2ResourceHandleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceHandles.size(); ++i) {
            if (!predicate.test(this.resourceHandles.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceHandles. No match found.");
        }
        return this.setNewResourceHandleLike(index, this.buildResourceHandle(index));
    }

    @Override
    public Boolean getShareable() {
        return this.shareable;
    }

    @Override
    public A withShareable(Boolean shareable) {
        this.shareable = shareable;
        return (A)this;
    }

    @Override
    public Boolean hasShareable() {
        return this.shareable != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2AllocationResultFluentImpl that = (V1alpha2AllocationResultFluentImpl)o;
        if (!Objects.equals(this.availableOnNodes, that.availableOnNodes)) {
            return false;
        }
        if (!Objects.equals(this.resourceHandles, that.resourceHandles)) {
            return false;
        }
        return Objects.equals(this.shareable, that.shareable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.availableOnNodes, this.resourceHandles, this.shareable, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availableOnNodes != null) {
            sb.append("availableOnNodes:");
            sb.append(this.availableOnNodes + ",");
        }
        if (this.resourceHandles != null) {
            sb.append("resourceHandles:");
            sb.append(this.resourceHandles + ",");
        }
        if (this.shareable != null) {
            sb.append("shareable:");
            sb.append(this.shareable);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withShareable() {
        return this.withShareable(true);
    }

    class AvailableOnNodesNestedImpl<N>
    extends V1NodeSelectorFluentImpl<V1alpha2AllocationResultFluent.AvailableOnNodesNested<N>>
    implements V1alpha2AllocationResultFluent.AvailableOnNodesNested<N>,
    Nested<N> {
        V1NodeSelectorBuilder builder;

        AvailableOnNodesNestedImpl(V1NodeSelector item) {
            this.builder = new V1NodeSelectorBuilder(this, item);
        }

        AvailableOnNodesNestedImpl() {
            this.builder = new V1NodeSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha2AllocationResultFluentImpl.this.withAvailableOnNodes(this.builder.build());
        }

        @Override
        public N endAvailableOnNodes() {
            return this.and();
        }
    }

    class ResourceHandlesNestedImpl<N>
    extends V1alpha2ResourceHandleFluentImpl<V1alpha2AllocationResultFluent.ResourceHandlesNested<N>>
    implements V1alpha2AllocationResultFluent.ResourceHandlesNested<N>,
    Nested<N> {
        V1alpha2ResourceHandleBuilder builder;
        int index;

        ResourceHandlesNestedImpl(int index, V1alpha2ResourceHandle item) {
            this.index = index;
            this.builder = new V1alpha2ResourceHandleBuilder(this, item);
        }

        ResourceHandlesNestedImpl() {
            this.index = -1;
            this.builder = new V1alpha2ResourceHandleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha2AllocationResultFluentImpl.this.setToResourceHandles(this.index, this.builder.build());
        }

        @Override
        public N endResourceHandle() {
            return this.and();
        }
    }
}

