/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.PendingSegmentAllocatingTask;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.security.ResourceAction;

public class NoopTask
extends AbstractTask
implements PendingSegmentAllocatingTask {
    private static final Logger log = new Logger(NoopTask.class);
    public static final String TYPE = "noop";
    public static final String EVENT_STARTED = "task/noop/started";
    private static final int DEFAULT_RUN_TIME = 2500;
    private final CountDownLatch isShutdown = new CountDownLatch(1);
    private final long runTime;

    @JsonCreator
    public NoopTask(@JsonProperty(value="id") String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="runTime") long runTimeMillis, @JsonProperty(value="isReadyTime") long isReadyTime, @JsonProperty(value="context") Map<String, Object> context) {
        super(id == null ? StringUtils.format((String)"noop_%s_%s", (Object[])new Object[]{DateTimes.nowUtc(), UUID.randomUUID().toString()}) : id, groupId, null, dataSource == null ? "none" : dataSource, context);
        this.runTime = runTimeMillis == 0L ? 2500L : runTimeMillis;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return ImmutableSet.of();
    }

    @JsonProperty
    public long getRunTime() {
        return this.runTime;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) {
        return true;
    }

    @Override
    public void stopGracefully(TaskConfig taskConfig) {
        this.isShutdown.countDown();
    }

    @Override
    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        log.info("Running task[%s] for [%d] millis", new Object[]{this.getId(), this.runTime});
        this.emitMetric(toolbox.getEmitter(), EVENT_STARTED, 1);
        if (this.isShutdown.await(this.runTime, TimeUnit.MILLISECONDS)) {
            return TaskStatus.failure((String)this.getId(), (String)"Canceled");
        }
        return TaskStatus.success((String)this.getId());
    }

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 50);
    }

    @Override
    public String getTaskAllocatorId() {
        return this.getId();
    }

    public static NoopTask create() {
        return NoopTask.forDatasource(null);
    }

    public static NoopTask forDatasource(String datasource) {
        return new NoopTask(null, null, datasource, 0L, 0L, null);
    }

    public static NoopTask ofPriority(int priority) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("priority", priority);
        return new NoopTask(null, null, null, 0L, 0L, context);
    }
}

