/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ForkingTaskRunnerConfig {
    public static final String JAVA_OPTS_PROPERTY = "druid.indexer.runner.javaOpts";
    public static final String JAVA_OPTS_ARRAY_PROPERTY = "druid.indexer.runner.javaOptsArray";
    @JsonProperty
    @NotNull
    private String javaCommand = "java";
    @JsonProperty
    @NotNull
    private String javaOpts = "";
    @JsonProperty
    @NotNull
    private List<String> javaOptsArray = ImmutableList.of();
    @JsonProperty
    @NotNull
    private String classpath = System.getProperty("java.class.path");
    @JsonProperty
    @Min(value=1024L)
    @Max(value=65535L)
    private @Min(value=1024L) @Max(value=65535L) int startPort = 8100;
    @JsonProperty
    @Min(value=1024L)
    @Max(value=65535L)
    private @Min(value=1024L) @Max(value=65535L) int endPort = 65535;
    @JsonProperty
    @NotNull
    private List<Integer> ports = ImmutableList.of();
    @JsonProperty
    @NotNull
    List<String> allowedPrefixes = Lists.newArrayList((Object[])new String[]{"com.metamx", "druid", "org.apache.druid", "user.timezone", "file.encoding", "java.io.tmpdir", "hadoop"});

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public List<String> getJavaOptsArray() {
        return this.javaOptsArray;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public List<String> getAllowedPrefixes() {
        return this.allowedPrefixes;
    }
}

