/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation.schema.primitive;

import com.azure.storage.internal.avro.implementation.AvroParserState;
import com.azure.storage.internal.avro.implementation.schema.AvroCompositeSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroBytesSchema;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;

public class AvroStringSchema
extends AvroCompositeSchema {
    public AvroStringSchema(AvroParserState state, Consumer<Object> onResult) {
        super(state, onResult);
    }

    @Override
    public void pushToStack() {
        this.state.pushToStack(this);
        AvroBytesSchema bytesSchema = new AvroBytesSchema(this.state, this::onBytes);
        bytesSchema.pushToStack();
    }

    private void onBytes(Object bytes) {
        AvroStringSchema.checkType("bytes", bytes, List.class);
        byte[] str = AvroSchema.getBytes((List)bytes);
        this.result = new String(str, StandardCharsets.UTF_8);
        this.done = true;
    }
}

