/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class ReflectionBeanMapper<T>
implements ResultSetMapper<T> {
    private final Class<T> type;
    private final Map<String, Field> properties = new HashMap<String, Field>();

    public ReflectionBeanMapper(Class<T> type) {
        this.type = type;
        this.cacheAllFieldsIncludingSuperClass(type);
    }

    private void cacheAllFieldsIncludingSuperClass(Class<T> type) {
        for (Class<T> aClass = type; aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                this.properties.put(field.getName().toLowerCase(), field);
            }
        }
    }

    @Override
    public T map(int row, ResultSet rs, StatementContext ctx) throws SQLException {
        T bean;
        try {
            bean = this.type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("A bean, %s, was mapped which was not instantiable", this.type.getName()), e);
        }
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String name = metadata.getColumnLabel(i).toLowerCase();
            Field field = this.properties.get(name);
            if (field == null) continue;
            Class<Object> type = field.getType();
            Object value = type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE) ? Boolean.valueOf(rs.getBoolean(i)) : (type.isAssignableFrom(Byte.class) || type.isAssignableFrom(Byte.TYPE) ? Byte.valueOf(rs.getByte(i)) : (type.isAssignableFrom(Short.class) || type.isAssignableFrom(Short.TYPE) ? Short.valueOf(rs.getShort(i)) : (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE) ? Integer.valueOf(rs.getInt(i)) : (type.isAssignableFrom(Long.class) || type.isAssignableFrom(Long.TYPE) ? Long.valueOf(rs.getLong(i)) : (type.isAssignableFrom(Float.class) || type.isAssignableFrom(Float.TYPE) ? Float.valueOf(rs.getFloat(i)) : (type.isAssignableFrom(Double.class) || type.isAssignableFrom(Double.TYPE) ? Double.valueOf(rs.getDouble(i)) : (type.isAssignableFrom(BigDecimal.class) ? rs.getBigDecimal(i) : (type.isAssignableFrom(Timestamp.class) ? rs.getTimestamp(i) : (type.isAssignableFrom(Time.class) ? rs.getTime(i) : (type.isAssignableFrom(Date.class) ? rs.getDate(i) : (type.isAssignableFrom(String.class) ? rs.getString(i) : (type.isEnum() ? Enum.valueOf(type, rs.getString(i)) : rs.getObject(i)))))))))))));
            if (rs.wasNull() && !type.isPrimitive()) {
                value = null;
            }
            try {
                field.setAccessible(true);
                field.set(bean, value);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Unable to access property, %s", name), e);
            }
        }
        return bean;
    }
}

