/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleVectorValueMatcher
implements VectorValueMatcherFactory {
    private final VectorValueSelector selector;

    public DoubleVectorValueMatcher(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(@Nullable String value) {
        if (value == null) {
            return VectorValueMatcher.nullMatcher(this.selector);
        }
        Double matchVal = DimensionHandlerUtils.convertObjectToDouble(value);
        if (matchVal == null) {
            return VectorValueMatcher.allFalseValueMatcher(this.selector);
        }
        return this.makeDoubleMatcher(matchVal);
    }

    @Override
    public VectorValueMatcher makeMatcher(Object matchValue, ColumnType matchValueType) {
        ExprEval<?> eval = ExprEval.ofType(ExpressionType.fromColumnType(matchValueType), matchValue);
        ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.DOUBLE);
        if (castForComparison == null || castForComparison.isNumericNull()) {
            return VectorValueMatcher.allFalseValueMatcher(this.selector);
        }
        return this.makeDoubleMatcher(castForComparison.asDouble());
    }

    private BaseVectorValueMatcher makeDoubleMatcher(final double matchValDouble) {
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[DoubleVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                double[] vector = DoubleVectorValueMatcher.this.selector.getDoubleVector();
                int[] selection = this.match.getSelection();
                boolean[] nulls = DoubleVectorValueMatcher.this.selector.getNullVector();
                boolean hasNulls = nulls != null;
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (hasNulls && nulls[rowNum]) {
                        if (!includeUnknown) continue;
                        selection[numRows++] = rowNum;
                        continue;
                    }
                    if (vector[rowNum] != matchValDouble) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }
        };
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        final DruidDoublePredicate predicate = predicateFactory.makeDoublePredicate();
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[DoubleVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                double[] vector = DoubleVectorValueMatcher.this.selector.getDoubleVector();
                int[] selection = this.match.getSelection();
                boolean[] nulls = DoubleVectorValueMatcher.this.selector.getNullVector();
                boolean hasNulls = nulls != null;
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (hasNulls && nulls[rowNum]) {
                        if (!predicate.applyNull().matches(includeUnknown)) continue;
                        selection[numRows++] = rowNum;
                        continue;
                    }
                    if (!predicate.applyDouble(vector[rowNum]).matches(includeUnknown)) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }
        };
    }
}

