/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.ByteBufferWriter;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSerializer;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ColumnSerializerUtils;
import org.apache.druid.segment.serde.ComplexColumnMetadata;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class CompressedComplexColumnSerializer<T>
implements GenericColumnSerializer<T> {
    public static final byte IS_COMPRESSED = 127;
    public static final byte V0 = 0;
    public static final String FILE_NAME = "__complexColumn";
    private final String name;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final IndexSpec indexSpec;
    private final ObjectStrategy<T> strategy;
    private CompressedVariableSizedBlobColumnSerializer writer;
    private ByteBufferWriter<ImmutableBitmap> nullBitmapWriter;
    private MutableBitmap nullRowsBitmap;
    private int rowCount = 0;
    private boolean closedForWrite = false;
    private byte[] metadataBytes;

    public static GenericColumnSerializer create(SegmentWriteOutMedium segmentWriteOutMedium, String column, IndexSpec indexSpec, ObjectStrategy objectStrategy) {
        return new CompressedComplexColumnSerializer(column, segmentWriteOutMedium, indexSpec, objectStrategy);
    }

    public CompressedComplexColumnSerializer(String name, SegmentWriteOutMedium segmentWriteOutMedium, IndexSpec indexSpec, ObjectStrategy<T> strategy) {
        this.name = name;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.indexSpec = indexSpec;
        this.strategy = strategy;
    }

    @Override
    public void open() throws IOException {
        this.writer = new CompressedVariableSizedBlobColumnSerializer(ColumnSerializerUtils.getInternalFileName(this.name, FILE_NAME), this.segmentWriteOutMedium, this.indexSpec.getComplexMetricCompression());
        this.writer.open();
        this.nullBitmapWriter = new ByteBufferWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        this.nullBitmapWriter.open();
        this.nullRowsBitmap = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
    }

    @Override
    public void serialize(ColumnValueSelector<? extends T> selector) throws IOException {
        Object data = selector.getObject();
        if (data == null) {
            this.nullRowsBitmap.add(this.rowCount);
        }
        ++this.rowCount;
        byte[] bytes = this.strategy.toBytes(data);
        this.writer.addValue(bytes);
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.closeForWrite();
        return 2 + this.metadataBytes.length;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        Preconditions.checkState((boolean)this.closedForWrite, (Object)"Not closed yet!");
        channel.write(ByteBuffer.wrap(new byte[]{127}));
        channel.write(ByteBuffer.wrap(new byte[]{0}));
        channel.write(ByteBuffer.wrap(this.metadataBytes));
        ColumnSerializerUtils.writeInternal(smoosher, this.writer, this.name, FILE_NAME);
        if (!this.nullRowsBitmap.isEmpty()) {
            ColumnSerializerUtils.writeInternal(smoosher, this.nullBitmapWriter, this.name, "__nullIndex");
        }
    }

    private void closeForWrite() throws IOException {
        if (!this.closedForWrite) {
            this.closedForWrite = true;
            this.nullBitmapWriter.write(this.nullRowsBitmap);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IndexMerger.SERIALIZER_UTILS.writeString(baos, ColumnSerializerUtils.SMILE_MAPPER.writeValueAsString((Object)new ComplexColumnMetadata(ByteOrder.nativeOrder(), this.indexSpec.getBitmapSerdeFactory(), this.name, !this.nullRowsBitmap.isEmpty())));
            this.metadataBytes = baos.toByteArray();
        }
    }
}

