/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import java.lang.reflect.InvocationTargetException;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.UOE;

@LazySingleton
public class RuntimeInfo {
    public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public long getMaxHeapSizeBytes() {
        return Runtime.getRuntime().maxMemory();
    }

    public long getTotalHeapSizeBytes() {
        return Runtime.getRuntime().totalMemory();
    }

    public long getFreeHeapSizeBytes() {
        return Runtime.getRuntime().freeMemory();
    }

    public long getDirectMemorySizeBytes() {
        try {
            Class<?> vmClass = Class.forName("jdk.internal.misc.VM");
            Object maxDirectMemoryObj = vmClass.getMethod("maxDirectMemory", new Class[0]).invoke(null, new Object[0]);
            if (maxDirectMemoryObj == null || !(maxDirectMemoryObj instanceof Number)) {
                throw new UOE("Cannot determine maxDirectMemory from [%s]", maxDirectMemoryObj);
            }
            return ((Number)maxDirectMemoryObj).longValue();
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("No VM class, cannot do memory check.", e);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("VM.maxDirectMemory doesn't exist, cannot do memory check.", e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("static method shouldn't throw this", e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("public method, shouldn't throw this", e);
        }
    }
}

