/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.druid.curator.CuratorConfig;
import org.apache.druid.curator.ZkEnablementConfig;
import org.apache.druid.curator.announcement.NodeAnnouncer;
import org.apache.druid.curator.announcement.PathChildrenAnnouncer;
import org.apache.druid.curator.announcement.ServiceAnnouncer;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ManageLifecycleAnnouncements;
import org.apache.druid.guice.annotations.DirectExecutorAnnouncer;
import org.apache.druid.guice.annotations.SingleThreadedAnnouncer;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.server.coordination.BatchDataSegmentAnnouncer;
import org.apache.druid.server.coordination.CuratorDataSegmentServerAnnouncer;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentAnnouncerProvider;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.initialization.BatchDataSegmentAnnouncerConfig;

public class AnnouncerModule
implements Module {
    private boolean isZkEnabled = true;

    @Inject
    public void configure(Properties properties) {
        this.isZkEnabled = ZkEnablementConfig.isEnabled(properties);
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.announcer", BatchDataSegmentAnnouncerConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.announcer", DataSegmentAnnouncerProvider.class);
        binder.bind(DataSegmentAnnouncer.class).toProvider(DataSegmentAnnouncerProvider.class);
        binder.bind(BatchDataSegmentAnnouncer.class).in(ManageLifecycleAnnouncements.class);
        if (this.isZkEnabled) {
            binder.bind(DataSegmentServerAnnouncer.class).to(CuratorDataSegmentServerAnnouncer.class).in(LazySingleton.class);
        } else {
            binder.bind(DataSegmentServerAnnouncer.class).to(DataSegmentServerAnnouncer.Noop.class).in(LazySingleton.class);
        }
    }

    @Provides
    @SingleThreadedAnnouncer
    @ManageLifecycleAnnouncements
    public ServiceAnnouncer getAnnouncerWithSingleThreadedExecutorService(CuratorFramework curator, CuratorConfig config) {
        boolean usingPathChildrenCacheAnnouncer = config.getPathChildrenCacheStrategy();
        if (usingPathChildrenCacheAnnouncer) {
            return new PathChildrenAnnouncer(curator, Execs.singleThreaded((String)"Announcer-%s"));
        }
        return new NodeAnnouncer(curator, Execs.singleThreaded((String)"Announcer-%s"));
    }

    @Provides
    @DirectExecutorAnnouncer
    @ManageLifecycleAnnouncements
    public ServiceAnnouncer getAnnouncerWithDirectExecutorService(CuratorFramework curator, CuratorConfig config) {
        boolean usingPathChildrenCacheAnnouncer = config.getPathChildrenCacheStrategy();
        if (usingPathChildrenCacheAnnouncer) {
            return new PathChildrenAnnouncer(curator, (ExecutorService)Execs.directExecutor());
        }
        return new NodeAnnouncer(curator, (ExecutorService)Execs.directExecutor());
    }
}

