/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.druid.error.DruidException;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.segment.SegmentMetadataReadTransaction;
import org.apache.druid.metadata.segment.SegmentMetadataTransaction;
import org.apache.druid.metadata.segment.SegmentMetadataTransactionFactory;
import org.apache.druid.metadata.segment.SqlSegmentMetadataTransaction;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TransactionStatus;

public class SqlSegmentMetadataReadOnlyTransactionFactory
implements SegmentMetadataTransactionFactory {
    private static final int QUIET_RETRIES = 2;
    private static final int MAX_RETRIES = 3;
    private final ObjectMapper jsonMapper;
    private final MetadataStorageTablesConfig tablesConfig;
    private final SQLMetadataConnector connector;

    @Inject
    public SqlSegmentMetadataReadOnlyTransactionFactory(ObjectMapper jsonMapper, MetadataStorageTablesConfig tablesConfig, SQLMetadataConnector connector) {
        this.jsonMapper = jsonMapper;
        this.tablesConfig = tablesConfig;
        this.connector = connector;
    }

    public int getMaxRetries() {
        return 3;
    }

    public int getQuietRetries() {
        return 2;
    }

    @Override
    public <T> T inReadOnlyDatasourceTransaction(String dataSource, SegmentMetadataReadTransaction.Callback<T> callback) {
        return this.connector.retryReadOnlyTransaction((handle, status) -> {
            SegmentMetadataTransaction sqlTransaction = this.createSqlTransaction(dataSource, handle, status);
            return this.executeReadAndClose(sqlTransaction, callback);
        }, 2, this.getMaxRetries());
    }

    @Override
    public <T> T inReadWriteDatasourceTransaction(String dataSource, SegmentMetadataTransaction.Callback<T> callback) {
        throw DruidException.defensive((String)"Only Overlord can perform write transactions on segment metadata.", (Object[])new Object[0]);
    }

    protected SegmentMetadataTransaction createSqlTransaction(String dataSource, Handle handle, TransactionStatus transactionStatus) {
        return new SqlSegmentMetadataTransaction(dataSource, handle, transactionStatus, this.connector, this.tablesConfig, this.jsonMapper);
    }

    protected <T> T executeReadAndClose(SegmentMetadataReadTransaction transaction, SegmentMetadataReadTransaction.Callback<T> callback) throws Exception {
        try (SegmentMetadataReadTransaction segmentMetadataReadTransaction = transaction;){
            T t = callback.inTransaction(transaction);
            return t;
        }
    }
}

