/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

public final class SegmentIdWithShardSpec
implements Comparable<SegmentIdWithShardSpec> {
    private final SegmentId id;
    private final ShardSpec shardSpec;
    private final String asString;

    @JsonCreator
    public SegmentIdWithShardSpec(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="shardSpec") ShardSpec shardSpec) {
        this.id = SegmentId.of((String)dataSource, (Interval)interval, (String)version, (int)shardSpec.getPartitionNum());
        this.shardSpec = (ShardSpec)Preconditions.checkNotNull((Object)shardSpec, (Object)"shardSpec");
        this.asString = this.id.toString();
    }

    public SegmentId asSegmentId() {
        return this.id;
    }

    @JsonProperty
    public String getDataSource() {
        return this.id.getDataSource();
    }

    @JsonProperty
    public Interval getInterval() {
        return this.id.getInterval();
    }

    @JsonProperty
    public String getVersion() {
        return this.id.getVersion();
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SegmentIdWithShardSpec)) {
            return false;
        }
        SegmentIdWithShardSpec that = (SegmentIdWithShardSpec)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(SegmentIdWithShardSpec o) {
        return this.id.compareTo(o.id);
    }

    public String toString() {
        return this.asString;
    }

    public static SegmentIdWithShardSpec fromDataSegment(DataSegment segment) {
        return new SegmentIdWithShardSpec(segment.getDataSource(), segment.getInterval(), segment.getVersion(), segment.getShardSpec());
    }
}

