/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionSegmentIterator;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.compaction.DataSourceCompactibleSegmentIterator;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.timeline.SegmentTimeline;
import org.joda.time.Interval;

public class PriorityBasedCompactionSegmentIterator
implements CompactionSegmentIterator {
    private static final Logger log = new Logger(PriorityBasedCompactionSegmentIterator.class);
    private final PriorityQueue<CompactionCandidate> queue = new PriorityQueue(searchPolicy::compareCandidates);
    private final Map<String, DataSourceCompactibleSegmentIterator> datasourceIterators;

    public PriorityBasedCompactionSegmentIterator(CompactionCandidateSearchPolicy searchPolicy, Map<String, DataSourceCompactionConfig> compactionConfigs, Map<String, SegmentTimeline> datasourceToTimeline, Map<String, List<Interval>> skipIntervals, CompactionStatusTracker statusTracker) {
        this.datasourceIterators = Maps.newHashMapWithExpectedSize((int)datasourceToTimeline.size());
        compactionConfigs.forEach((datasource, config) -> {
            if (config == null) {
                throw DruidException.defensive((String)"Invalid null compaction config for dataSource[%s].", (Object[])new Object[]{datasource});
            }
            SegmentTimeline timeline = (SegmentTimeline)datasourceToTimeline.get(datasource);
            if (timeline == null) {
                log.warn("Skipping compaction for datasource[%s] as it has no timeline.", new Object[]{datasource});
                return;
            }
            this.datasourceIterators.put((String)datasource, new DataSourceCompactibleSegmentIterator((DataSourceCompactionConfig)compactionConfigs.get(datasource), timeline, skipIntervals.getOrDefault(datasource, Collections.emptyList()), searchPolicy, statusTracker));
            this.addNextItemForDatasourceToQueue((String)datasource);
        });
    }

    @Override
    public List<CompactionCandidate> getCompactedSegments() {
        return this.datasourceIterators.values().stream().flatMap(iterator -> iterator.getCompactedSegments().stream()).collect(Collectors.toList());
    }

    @Override
    public List<CompactionCandidate> getSkippedSegments() {
        return this.datasourceIterators.values().stream().flatMap(iterator -> iterator.getSkippedSegments().stream()).collect(Collectors.toList());
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public CompactionCandidate next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        CompactionCandidate entry = this.queue.poll();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        this.addNextItemForDatasourceToQueue(entry.getDataSource());
        return entry;
    }

    private void addNextItemForDatasourceToQueue(String dataSourceName) {
        CompactionCandidate compactionCandidate;
        DataSourceCompactibleSegmentIterator iterator = this.datasourceIterators.get(dataSourceName);
        if (iterator.hasNext() && (compactionCandidate = iterator.next()) != null) {
            this.queue.add(compactionCandidate);
        }
    }
}

