/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.servlet.Filter;
import org.apache.druid.server.security.AllowOptionsResourceFilter;
import org.apache.druid.server.security.AuthenticationOnlyResourceFilter;
import org.apache.druid.server.security.AuthenticationWrappingFilter;
import org.apache.druid.server.security.Authenticator;
import org.apache.druid.server.security.PreResponseAuthorizationCheckFilter;
import org.apache.druid.server.security.SecuritySanityCheckFilter;
import org.apache.druid.server.security.UnsecuredResourceFilter;
import org.eclipse.jetty.ee8.servlet.FilterHolder;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;

public class AuthenticationUtils {
    public static void addAllowOptionsFilter(ServletContextHandler root, boolean allowUnauthenticatedHttpOptions) {
        FilterHolder holder = new FilterHolder((Filter)new AllowOptionsResourceFilter(allowUnauthenticatedHttpOptions));
        root.addFilter(holder, "/*", null);
    }

    public static void addAuthenticationFilterChain(ServletContextHandler root, List<Authenticator> authenticators) {
        for (Authenticator authenticator : authenticators) {
            FilterHolder holder = new FilterHolder((Filter)new AuthenticationWrappingFilter(authenticator.getFilter()));
            if (authenticator.getInitParameters() != null) {
                holder.setInitParameters(authenticator.getInitParameters());
            }
            root.addFilter(holder, "/*", null);
        }
    }

    public static void addNoopAuthenticationAndAuthorizationFilters(ServletContextHandler root, List<String> unsecuredPaths) {
        for (String unsecuredPath : unsecuredPaths) {
            root.addFilter(new FilterHolder((Filter)new UnsecuredResourceFilter()), unsecuredPath, null);
        }
    }

    public static void addNoopAuthorizationFilters(ServletContextHandler root, List<String> unsecuredPaths) {
        for (String unsecuredPath : unsecuredPaths) {
            root.addFilter(new FilterHolder((Filter)new AuthenticationOnlyResourceFilter()), unsecuredPath, null);
        }
    }

    public static void addSecuritySanityCheckFilter(ServletContextHandler root, ObjectMapper jsonMapper) {
        root.addFilter(new FilterHolder((Filter)new SecuritySanityCheckFilter(jsonMapper)), "/*", null);
    }

    public static void addPreResponseAuthorizationCheckFilter(ServletContextHandler root, List<Authenticator> authenticators, ObjectMapper jsonMapper) {
        root.addFilter(new FilterHolder((Filter)new PreResponseAuthorizationCheckFilter(authenticators, jsonMapper)), "/*", null);
    }
}

