/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;

public class HllSketchHolder {
    private Union union;
    private HllSketch sketch;

    public static HllSketchHolder fromObj(Object obj) {
        if (obj == null) {
            throw new NullPointerException("HllSketchHolder.fromObj cannot take a null argument");
        }
        if (obj instanceof HllSketchHolder) {
            return (HllSketchHolder)obj;
        }
        if (obj instanceof HllSketch) {
            return HllSketchHolder.of((HllSketch)obj);
        }
        if (obj instanceof Union) {
            return HllSketchHolder.of((Union)obj);
        }
        if (obj instanceof byte[]) {
            return HllSketchHolder.of(HllSketch.heapify((byte[])((byte[])obj)));
        }
        if (obj instanceof Memory) {
            return HllSketchHolder.of(HllSketch.wrap((Memory)((Memory)obj)));
        }
        if (obj instanceof String) {
            return HllSketchHolder.of(HllSketch.heapify((byte[])StringUtils.decodeBase64((byte[])StringUtils.toUtf8((String)((String)obj)))));
        }
        throw new ISE("Object is not of a type[%s] that can be deserialized to sketch.", new Object[]{obj.getClass()});
    }

    public static HllSketchHolder of(Union union) {
        return new HllSketchHolder(union, null);
    }

    public static HllSketchHolder of(HllSketch sketch) {
        return new HllSketchHolder(null, sketch);
    }

    public HllSketchHolder(Union union, HllSketch sketch) {
        this.union = union;
        this.sketch = sketch;
        if (this.union == null && this.sketch == null) {
            throw new ISE("Both union and sketch were null!", new Object[0]);
        }
    }

    @JsonValue
    public HllSketch getSketch() {
        if (this.sketch == null) {
            this.sketch = this.union.getResult();
        }
        return this.sketch;
    }

    public HllSketch getSketch(TgtHllType type) {
        if (this.sketch == null) {
            this.sketch = this.union.getResult(type);
        }
        if (this.sketch.getTgtHllType() != type) {
            this.sketch = this.sketch.copyAs(type);
        }
        return this.sketch;
    }

    public void add(HllSketch sketchToAdd) {
        if (this.union == null) {
            this.union = new Union(sketchToAdd.getLgConfigK());
            this.union.update(this.sketch);
        }
        this.union.update(sketchToAdd);
        this.sketch = null;
    }

    public double getEstimate() {
        if (this.sketch != null) {
            return this.sketch.getEstimate();
        }
        if (this.union != null) {
            return this.union.getEstimate();
        }
        return 0.0;
    }

    public double getLowerBound(int stdDevs) {
        if (this.sketch != null) {
            return this.sketch.getLowerBound(stdDevs);
        }
        if (this.union != null) {
            return this.union.getLowerBound(stdDevs);
        }
        return 0.0;
    }

    public double getUpperBound(int stdDevs) {
        if (this.sketch != null) {
            return this.sketch.getUpperBound(stdDevs);
        }
        if (this.union != null) {
            return this.union.getUpperBound(stdDevs);
        }
        return 0.0;
    }

    public HllSketchHolder merge(HllSketchHolder other) {
        if (this.union == null) {
            if (other.union == null) {
                this.add(other.getSketch());
                return this;
            }
            other.add(this.sketch);
            return other;
        }
        this.add(other.getSketch());
        return this;
    }

    public String toString() {
        return "HllSketchHolder{" + (this.union != null ? this.union.toString() : this.sketch.toString()) + "}";
    }
}

