/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.Arrays;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.planner.plan.utils.LookupJoinUtil;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.keyselector.BinaryRowDataKeySelector;
import org.apache.flink.table.runtime.keyselector.EmptyRowDataKeySelector;
import org.apache.flink.table.runtime.keyselector.GenericRowDataKeySelector;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class KeySelectorUtil {
    public static RowDataKeySelector getRowDataSelector(ClassLoader classLoader, int[] keyFields, InternalTypeInfo<RowData> rowType) {
        return KeySelectorUtil.getRowDataSelector(classLoader, keyFields, rowType, BinaryRowData.class);
    }

    public static RowDataKeySelector getRowDataSelector(ClassLoader classLoader, int[] keyFields, InternalTypeInfo<RowData> rowType, Class<? extends RowData> outClass) {
        if (keyFields.length > 0) {
            LogicalType[] inputFieldTypes = rowType.toRowFieldTypes();
            LogicalType[] keyFieldTypes = new LogicalType[keyFields.length];
            for (int i = 0; i < keyFields.length; ++i) {
                keyFieldTypes[i] = inputFieldTypes[keyFields[i]];
            }
            RowType returnType = RowType.of((LogicalType[])keyFieldTypes);
            RowType inputType = rowType.toRowType();
            GeneratedProjection generatedProjection = ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), classLoader), "KeyProjection", inputType, returnType, keyFields, outClass);
            InternalTypeInfo keyRowType = InternalTypeInfo.of((RowType)returnType);
            if (outClass == BinaryRowData.class) {
                return new BinaryRowDataKeySelector(keyRowType, generatedProjection);
            }
            if (outClass == GenericRowData.class) {
                RowDataSerializer keySerializer = InternalSerializers.create((RowType)returnType);
                return new GenericRowDataKeySelector(keyRowType, keySerializer, generatedProjection);
            }
            throw new UnsupportedOperationException("Currently only GenericRowData and BinaryRowData supported as outClass of KeySelector.");
        }
        return EmptyRowDataKeySelector.INSTANCE;
    }

    public static RowDataKeySelector getLookupKeysSelectorFromLeftTable(ClassLoader classLoader, Map<Integer, LookupJoinUtil.LookupKey> lookupKeysOfRightTable, InternalTypeInfo<RowData> leftTableRowType) {
        LogicalType[] inputFieldTypes = leftTableRowType.toRowFieldTypes();
        int[] lookupKeyIndicesInOrder = LookupJoinUtil.getOrderedLookupKeys(lookupKeysOfRightTable.keySet());
        int[] inputMapping = new int[lookupKeysOfRightTable.size()];
        Arrays.fill(inputMapping, ProjectionCodeGenerator.EMPTY_INPUT_MAPPING_VALUE());
        LookupJoinUtil.LookupKey[] orderedLookupKeys = new LookupJoinUtil.LookupKey[lookupKeyIndicesInOrder.length];
        LogicalType[] orderedLookupKeyLogicalTypes = new LogicalType[lookupKeysOfRightTable.size()];
        int cnt = 0;
        for (int idx : lookupKeyIndicesInOrder) {
            LookupJoinUtil.LookupKey key = lookupKeysOfRightTable.get(idx);
            if (key instanceof LookupJoinUtil.ConstantLookupKey) {
                LogicalType keyType;
                orderedLookupKeyLogicalTypes[cnt] = keyType = ((LookupJoinUtil.ConstantLookupKey)key).sourceType;
            } else if (key instanceof LookupJoinUtil.FieldRefLookupKey) {
                int leftIdx;
                inputMapping[cnt] = leftIdx = ((LookupJoinUtil.FieldRefLookupKey)key).index;
                orderedLookupKeyLogicalTypes[cnt] = inputFieldTypes[leftIdx];
            } else {
                throw new UnsupportedOperationException("The lookup key " + key + " is invalid.");
            }
            orderedLookupKeys[cnt] = key;
            ++cnt;
        }
        RowType orderedLookupKeyRowType = RowType.of((LogicalType[])orderedLookupKeyLogicalTypes);
        GeneratedProjection generatedProjection = ProjectionCodeGenerator.generateProjectionForLookupKeysFromLeftTable(orderedLookupKeys, new CodeGeneratorContext((ReadableConfig)new Configuration(), classLoader), "LookupKeyProjection", leftTableRowType.toRowType(), orderedLookupKeyRowType, inputMapping, GenericRowData.class);
        return new GenericRowDataKeySelector(InternalTypeInfo.of((RowType)orderedLookupKeyRowType), InternalSerializers.create((RowType)orderedLookupKeyRowType), generatedProjection);
    }
}

