/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.model.ConditionItem;
import com.aliyun.oss.model.MatchMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolicyConditions {
    public static final String COND_CONTENT_LENGTH_RANGE = "content-length-range";
    public static final String COND_CACHE_CONTROL = "Cache-Control";
    public static final String COND_CONTENT_TYPE = "Content-Type";
    public static final String COND_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String COND_CONTENT_ENCODING = "Content-Encoding";
    public static final String COND_EXPIRES = "Expires";
    public static final String COND_KEY = "key";
    public static final String COND_SUCCESS_ACTION_REDIRECT = "success_action_redirect";
    public static final String COND_SUCCESS_ACTION_STATUS = "success_action_status";
    public static final String COND_X_OSS_META_PREFIX = "x-oss-meta-";
    public static final String COND_X_OSS_SERVER_SIDE_PREFIX = "x-oss-server-side-";
    private static Map<String, List<MatchMode>> _supportedMatchRules = new HashMap<String, List<MatchMode>>();
    private List<ConditionItem> _conds = new ArrayList<ConditionItem>();

    public void addConditionItem(String name, String value) {
        this.checkMatchModes(MatchMode.Exact, name);
        this._conds.add(new ConditionItem(name, value));
    }

    public void addConditionItem(MatchMode matchMode, String name, String value) {
        this.checkMatchModes(matchMode, name);
        this._conds.add(new ConditionItem(matchMode, name, value));
    }

    public void addConditionItem(String name, long min2, long max) {
        if (min2 > max) {
            throw new IllegalArgumentException(String.format("Invalid range [%d, %d].", min2, max));
        }
        this._conds.add(new ConditionItem(name, min2, max));
    }

    public void addConditionItem(MatchMode matchMode, String name, String[] contain) {
        this.checkMatchModes(matchMode, name);
        this._conds.add(new ConditionItem(matchMode, name.toLowerCase(), contain));
    }

    private void checkMatchModes(MatchMode matchMode, String condName) {
        List<MatchMode> mms;
        if (_supportedMatchRules.containsKey(condName) && !(mms = _supportedMatchRules.get(condName)).contains((Object)matchMode)) {
            throw new IllegalArgumentException(String.format("Unsupported match mode for condition item %s", condName));
        }
    }

    public String jsonize() {
        StringBuilder jsonizedConds = new StringBuilder();
        jsonizedConds.append("\"conditions\":[");
        for (ConditionItem cond : this._conds) {
            jsonizedConds.append(cond.jsonize());
        }
        if (this._conds.size() > 0) {
            jsonizedConds.deleteCharAt(jsonizedConds.length() - 1);
        }
        jsonizedConds.append("]");
        return jsonizedConds.toString();
    }

    static {
        ArrayList<MatchMode> ordinaryMatchModes = new ArrayList<MatchMode>();
        ordinaryMatchModes.add(MatchMode.Exact);
        ordinaryMatchModes.add(MatchMode.StartWith);
        ordinaryMatchModes.add(MatchMode.In);
        ordinaryMatchModes.add(MatchMode.NotIn);
        ArrayList<MatchMode> specialMatchModes = new ArrayList<MatchMode>();
        specialMatchModes.add(MatchMode.Range);
        _supportedMatchRules.put(COND_CONTENT_LENGTH_RANGE, specialMatchModes);
        _supportedMatchRules.put(COND_CACHE_CONTROL, ordinaryMatchModes);
        _supportedMatchRules.put(COND_CONTENT_TYPE, ordinaryMatchModes);
        _supportedMatchRules.put(COND_CONTENT_DISPOSITION, ordinaryMatchModes);
        _supportedMatchRules.put(COND_CONTENT_ENCODING, ordinaryMatchModes);
        _supportedMatchRules.put(COND_EXPIRES, ordinaryMatchModes);
        _supportedMatchRules.put(COND_KEY, ordinaryMatchModes);
        _supportedMatchRules.put(COND_SUCCESS_ACTION_REDIRECT, ordinaryMatchModes);
        _supportedMatchRules.put(COND_SUCCESS_ACTION_STATUS, ordinaryMatchModes);
        _supportedMatchRules.put(COND_X_OSS_META_PREFIX, ordinaryMatchModes);
        _supportedMatchRules.put(COND_X_OSS_SERVER_SIDE_PREFIX, ordinaryMatchModes);
    }
}

