/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.materializedtable;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.DropOperation;
import org.apache.flink.table.operations.materializedtable.MaterializedTableOperation;

@Internal
public class DropMaterializedTableOperation
implements DropOperation,
MaterializedTableOperation {
    private final ObjectIdentifier tableIdentifier;
    private final boolean ifExists;

    public DropMaterializedTableOperation(ObjectIdentifier tableIdentifier, boolean ifExists) {
        this.tableIdentifier = tableIdentifier;
        this.ifExists = ifExists;
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.getTableIdentifier());
        params.put("IfExists", this.isIfExists());
        return OperationUtils.formatWithChildren("DROP MATERIALIZED TABLE", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ctx.getCatalogManager().dropMaterializedTable(this.getTableIdentifier(), this.isIfExists());
        return TableResultImpl.TABLE_RESULT_OK;
    }
}

