/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.generated;

import java.io.Serializable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.codesplit.JavaCodeSplitter;
import org.apache.flink.table.runtime.generated.CompileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneratedClass<T>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratedClass.class);
    private final String className;
    private final String code;
    private final String splitCode;
    private final Object[] references;
    private transient Class<T> compiledClass;

    protected GeneratedClass(String className, String code, Object[] references, ReadableConfig config) {
        Preconditions.checkNotNull((Object)className, (String)"name must not be null");
        Preconditions.checkNotNull((Object)code, (String)"code must not be null");
        Preconditions.checkNotNull((Object)references, (String)"references must not be null");
        Preconditions.checkNotNull((Object)config, (String)"config must not be null");
        this.className = className;
        this.code = code;
        this.splitCode = code.isEmpty() ? code : JavaCodeSplitter.split(code, (Integer)config.get(TableConfigOptions.MAX_LENGTH_GENERATED_CODE), (Integer)config.get(TableConfigOptions.MAX_MEMBERS_GENERATED_CODE));
        this.references = references;
    }

    public T newInstance(ClassLoader classLoader) {
        try {
            return this.compile(classLoader).getConstructor(Object[].class).newInstance(new Object[]{this.references});
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not instantiate generated class '" + this.className + "'", e);
        }
    }

    public T newInstance(ClassLoader classLoader, Object ... args) {
        try {
            return (T)this.compile(classLoader).getConstructors()[0].newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate generated class '" + this.className + "'", e);
        }
    }

    public Class<T> compile(ClassLoader classLoader) {
        if (this.compiledClass == null) {
            try {
                this.compiledClass = CompileUtils.compile(classLoader, this.className, this.splitCode);
            }
            catch (Throwable t) {
                LOG.warn("Failed to compile split code, falling back to original code", t);
                this.compiledClass = CompileUtils.compile(classLoader, this.className, this.code);
            }
        }
        return this.compiledClass;
    }

    public String getClassName() {
        return this.className;
    }

    public String getCode() {
        return this.code;
    }

    public Object[] getReferences() {
        return this.references;
    }

    public Class<T> getClass(ClassLoader classLoader) {
        return this.compile(classLoader);
    }
}

