/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.maxwell;

import java.util.Objects;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.formats.json.JsonRowDataSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.RowKind;

public class MaxwellJsonSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final StringData OP_INSERT = StringData.fromString((String)"insert");
    private static final StringData OP_DELETE = StringData.fromString((String)"delete");
    private final JsonRowDataSerializationSchema jsonSerializer;
    private final TimestampFormat timestampFormat;
    private transient GenericRowData reuse;

    public MaxwellJsonSerializationSchema(RowType rowType, TimestampFormat timestampFormat, JsonFormatOptions.MapNullKeyMode mapNullKeyMode, String mapNullKeyLiteral, boolean encodeDecimalAsPlainNumber, boolean ignoreNullFields) {
        this.jsonSerializer = new JsonRowDataSerializationSchema(this.createJsonRowType(TypeConversions.fromLogicalToDataType((LogicalType)rowType)), timestampFormat, mapNullKeyMode, mapNullKeyLiteral, encodeDecimalAsPlainNumber, ignoreNullFields);
        this.timestampFormat = timestampFormat;
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.jsonSerializer.open(context);
        this.reuse = new GenericRowData(2);
    }

    public byte[] serialize(RowData element) {
        this.reuse.setField(0, (Object)element);
        this.reuse.setField(1, (Object)this.rowKind2String(element.getRowKind()));
        return this.jsonSerializer.serialize((RowData)this.reuse);
    }

    private StringData rowKind2String(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: 
            case UPDATE_AFTER: {
                return OP_INSERT;
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                return OP_DELETE;
            }
        }
        throw new UnsupportedOperationException("Unsupported operation '" + String.valueOf(rowKind) + "' for row kind.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaxwellJsonSerializationSchema that = (MaxwellJsonSerializationSchema)o;
        return Objects.equals(this.jsonSerializer, that.jsonSerializer) && this.timestampFormat == that.timestampFormat;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jsonSerializer, this.timestampFormat});
    }

    private RowType createJsonRowType(DataType databaseSchema) {
        DataType payload = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"data", (DataType)databaseSchema), DataTypes.FIELD((String)"type", (DataType)DataTypes.STRING())});
        return (RowType)payload.getLogicalType();
    }
}

