/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog;

import io.trino.jdbc.TrinoDriver;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorContext;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.gravitino.trino.connector.GravitinoConfig;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.metadata.GravitinoCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogRegister {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogRegister.class);
    private static final int MIN_SUPPORT_TRINO_SPI_VERSION = 435;
    private static final int MAX_SUPPORT_TRINO_SPI_VERSION = 439;
    private static final int MIN_SUPPORT_CATALOG_NAME_WITH_METALAKE_TRINO_SPI_VERSION = 446;
    private static final int EXECUTE_QUERY_MAX_RETRIES = 6;
    private static final int EXECUTE_QUERY_BACKOFF_TIME_SECOND = 5;
    private String trinoVersion;
    private Connection connection;
    private boolean isCoordinator;
    private boolean isStarted = false;
    private String catalogStoreDirectory;
    private GravitinoConfig config;

    private void checkTrinoSpiVersion(ConnectorContext context) {
        this.trinoVersion = context.getSpiVersion();
        int version = Integer.parseInt(this.trinoVersion);
        if (version < 435 || version > 439) {
            Boolean skipTrinoVersionValidation = this.config.isSkipTrinoVersionValidation();
            if (!skipTrinoVersionValidation.booleanValue()) {
                String errmsg = String.format("Unsupported Trino-%s version. The Supported version for the Gravitino-Trino-connector from Trino-%d to Trino-%d.Maybe you can set gravitino.trino.skip-version-validation to skip version validation.", this.trinoVersion, 435, 439);
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_UNSUPPORTED_TRINO_VERSION, errmsg);
            }
            LOG.warn("The version %s has not undergone thorough testing with Gravitino, there may be compatiablity problem.", (Object)this.trinoVersion);
        }
        this.isCoordinator = context.getNodeManager().getCurrentNode().isCoordinator();
    }

    private void checkSupportCatalogNameWithMetalake(ConnectorContext context, GravitinoConfig config) {
        int version;
        if (!config.singleMetalakeMode() && (version = Integer.parseInt(context.getSpiVersion())) < 446) {
            LOG.warn("Trino-{} does not support catalog name with dots, The minimal required version is Trino-{}.Some errors may occur when using the USE <CATALOG>.<SCHEMA> statement in Trino", (Object)this.trinoVersion, (Object)446);
        }
    }

    boolean isCoordinator() {
        return this.isCoordinator;
    }

    boolean isTrinoStarted() {
        boolean bl;
        block9: {
            if (this.isStarted) {
                return true;
            }
            String command = "SELECT 1";
            Statement statement = this.connection.createStatement();
            try {
                bl = this.isStarted = statement.execute(command);
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("Trino server is not started: {}", (Object)e.getMessage());
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    public void init(ConnectorContext context, GravitinoConfig config) throws Exception {
        this.config = config;
        this.checkTrinoSpiVersion(context);
        this.checkSupportCatalogNameWithMetalake(context, config);
        TrinoDriver driver = new TrinoDriver();
        DriverManager.registerDriver((Driver)driver);
        Properties properties = new Properties();
        properties.put("user", config.getTrinoUser());
        properties.put("password", config.getTrinoPassword());
        try {
            this.connection = driver.connect(config.getTrinoJdbcURI(), properties);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Failed to initialize the Trino connection.", (Throwable)e);
        }
        this.catalogStoreDirectory = config.getCatalogConfigDirectory();
        if (!Files.exists(Path.of(this.catalogStoreDirectory, new String[0]), new LinkOption[0])) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_CONFIG, String.format("Error config for Trino catalog store directory %s, file not found", this.catalogStoreDirectory));
        }
    }

    private String generateCreateCatalogCommand(String name, GravitinoCatalog gravitinoCatalog) throws Exception {
        return String.format("CREATE CATALOG %s USING gravitino WITH ( \"%s\" = 'true', \"%s\" = '%s', %s)", name, "__gravitino.dynamic.connector", "__gravitino.dynamic.connector.catalog.config", GravitinoCatalog.toJson(gravitinoCatalog), this.config.toCatalogConfig());
    }

    private String generateDropCatalogCommand(String name) {
        return String.format("DROP CATALOG %s", name);
    }

    public void registerCatalog(String name, GravitinoCatalog catalog) {
        try {
            String catalogFileName = String.format("%s/%s.properties", this.catalogStoreDirectory, name);
            File catalogFile = new File(catalogFileName);
            if (catalogFile.exists()) {
                String catalogContents = Files.readString(catalogFile.toPath());
                if (!catalogContents.contains("__gravitino.dynamic.connector=true")) {
                    throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_DUPLICATED_CATALOGS, "Catalog already exists, the catalog is not created by Gravitino");
                }
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_CATALOG_ALREADY_EXISTS, String.format("Catalog %s in metalake %s already exists", catalog.getName(), catalog.getMetalake()));
            }
            if (this.checkCatalogExist(name)) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_DUPLICATED_CATALOGS, "Catalog already exists with unknown reason");
            }
            String createCatalogCommand = this.generateCreateCatalogCommand(name, catalog);
            this.executeSql(createCatalogCommand);
            LOG.info("Register catalog {} successfully: {}", (Object)name, (Object)createCatalogCommand);
        }
        catch (Exception e) {
            String message = String.format("Failed to register catalog %s", name);
            LOG.error(message);
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, message, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean checkCatalogExist(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeSql(String sql) {
        try {
            int retries = 6;
            Object failedException = new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Initial placeholder exception - this should be replaced with a real exception if retries fail.");
            while (retries-- > 0) {
                try (Statement statement = this.connection.createStatement();){
                    statement.execute(sql);
                    return;
                }
                catch (Exception e) {
                    failedException = e;
                    LOG.warn("Execute command failed: {}, ", (Object)sql, (Object)e);
                    Thread.sleep(5000L);
                }
            }
            throw failedException;
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Failed to execute query: " + sql, (Throwable)e);
        }
    }

    public void unregisterCatalog(String name) {
        try {
            if (!this.checkCatalogExist(name)) {
                LOG.warn("Catalog {} does not exist", (Object)name);
                return;
            }
            String dropCatalogCommand = this.generateDropCatalogCommand(name);
            this.executeSql(dropCatalogCommand);
            LOG.info("Unregister catalog {} successfully: {}", (Object)name, (Object)dropCatalogCommand);
        }
        catch (Exception e) {
            String message = String.format("Failed to unregister catalog %s", name);
            LOG.error(message);
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, message, (Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Failed to close connection", (Throwable)e);
        }
    }
}

