/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.radix.node.concrete.bytearray;

import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.concrete.bytearray.ByteArrayCharSequence;
import java.util.Collections;
import java.util.List;

public class ByteArrayNodeLeafWithValue
implements Node {
    private final byte[] incomingEdgeCharArray;
    private final Object value;

    public ByteArrayNodeLeafWithValue(CharSequence edgeCharSequence, Object value) {
        this.incomingEdgeCharArray = ByteArrayCharSequence.toSingleByteUtf8Encoding(edgeCharSequence);
        this.value = value;
    }

    @Override
    public CharSequence getIncomingEdge() {
        return new ByteArrayCharSequence(this.incomingEdgeCharArray, 0, this.incomingEdgeCharArray.length);
    }

    @Override
    public Character getIncomingEdgeFirstCharacter() {
        return Character.valueOf((char)(this.incomingEdgeCharArray[0] & 0xFF));
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Node getOutgoingEdge(Character edgeFirstCharacter) {
        return null;
    }

    @Override
    public void updateOutgoingEdge(Node childNode) {
        throw new IllegalStateException("Cannot update the reference to the following child node for the edge starting with '" + childNode.getIncomingEdgeFirstCharacter() + "', no such edge already exists: " + childNode);
    }

    @Override
    public List<Node> getOutgoingEdges() {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node{");
        sb.append("edge=").append(this.getIncomingEdge());
        sb.append(", value=").append(this.value);
        sb.append(", edges=[]");
        sb.append("}");
        return sb.toString();
    }
}

