/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.connector.OperationsProxy;
import org.apache.gravitino.connector.ProxyPlugin;
import org.apache.gravitino.connector.TableOperations;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;

@Evolving
public abstract class BaseTable
implements Table {
    protected String name;
    @Nullable
    protected String comment;
    @Nullable
    protected Map<String, String> properties;
    protected AuditInfo auditInfo;
    protected Column[] columns;
    @Nullable
    protected Transform[] partitioning;
    @Nullable
    protected SortOrder[] sortOrders;
    @Nullable
    protected Distribution distribution;
    @Nullable
    protected Index[] indexes;
    protected Optional<ProxyPlugin> proxyPlugin;
    private volatile TableOperations ops;

    @Evolving
    protected abstract TableOperations newOps() throws UnsupportedOperationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableOperations ops() {
        if (this.ops == null) {
            BaseTable baseTable = this;
            synchronized (baseTable) {
                if (this.ops == null) {
                    TableOperations newOps = this.newOps();
                    this.ops = this.proxyPlugin.map(plugin -> OperationsProxy.createProxy(newOps, plugin)).orElse(newOps);
                }
            }
        }
        return this.ops;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    public String name() {
        return this.name;
    }

    public Column[] columns() {
        return this.columns;
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Transform[] partitioning() {
        return this.partitioning;
    }

    public SortOrder[] sortOrder() {
        return this.sortOrders;
    }

    public Distribution distribution() {
        return this.distribution;
    }

    public Index[] index() {
        return this.indexes;
    }

    public Optional<ProxyPlugin> proxyPlugin() {
        return this.proxyPlugin;
    }

    public String toString() {
        return "BaseTable(name=" + this.name + ", comment=" + this.comment + ", properties=" + String.valueOf(this.properties) + ", auditInfo=" + String.valueOf(this.auditInfo) + ", columns=" + Arrays.deepToString(this.columns) + ", partitioning=" + Arrays.deepToString(this.partitioning) + ", sortOrders=" + Arrays.deepToString(this.sortOrders) + ", distribution=" + String.valueOf(this.distribution) + ", indexes=" + Arrays.deepToString(this.indexes) + ", proxyPlugin=" + String.valueOf(this.proxyPlugin) + ", ops=" + String.valueOf(this.ops) + ")";
    }

    public static abstract class BaseTableBuilder<SELF extends Builder<SELF, T>, T extends BaseTable>
    implements Builder<SELF, T> {
        protected String name;
        protected String comment;
        protected Map<String, String> properties;
        protected AuditInfo auditInfo;
        protected Column[] columns;
        protected Transform[] partitioning;
        protected SortOrder[] sortOrders;
        protected Distribution distribution;
        protected Index[] indexes;
        protected Optional<ProxyPlugin> proxyPlugin = Optional.empty();

        @Override
        public SELF withName(String name) {
            this.name = name;
            return this.self();
        }

        @Override
        public SELF withComment(String comment) {
            this.comment = comment;
            return this.self();
        }

        @Override
        public SELF withColumns(Column[] columns) {
            this.columns = columns;
            return this.self();
        }

        @Override
        public SELF withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this.self();
        }

        @Override
        public SELF withAuditInfo(AuditInfo auditInfo) {
            this.auditInfo = auditInfo;
            return this.self();
        }

        @Override
        public SELF withPartitioning(Transform[] partitioning) {
            this.partitioning = partitioning;
            return this.self();
        }

        @Override
        public SELF withSortOrders(SortOrder[] sortOrders) {
            this.sortOrders = sortOrders;
            return (SELF)this;
        }

        @Override
        public SELF withDistribution(Distribution distribution) {
            this.distribution = distribution;
            return (SELF)this;
        }

        @Override
        public SELF withIndexes(Index[] indexes) {
            this.indexes = indexes;
            return (SELF)this;
        }

        @Override
        public SELF withProxyPlugin(ProxyPlugin proxyPlugin) {
            this.proxyPlugin = Optional.ofNullable(proxyPlugin);
            return (SELF)this;
        }

        @Override
        public T build() {
            T t = this.internalBuild();
            return t;
        }

        private SELF self() {
            return (SELF)this;
        }

        @Evolving
        protected abstract T internalBuild();
    }

    public static interface Builder<SELF extends Builder<SELF, T>, T extends BaseTable> {
        public SELF withName(String var1);

        public SELF withColumns(Column[] var1);

        public SELF withComment(String var1);

        public SELF withProperties(Map<String, String> var1);

        public SELF withAuditInfo(AuditInfo var1);

        public SELF withPartitioning(Transform[] var1);

        public SELF withSortOrders(SortOrder[] var1);

        public SELF withDistribution(Distribution var1);

        public SELF withIndexes(Index[] var1);

        public SELF withProxyPlugin(ProxyPlugin var1);

        public T build();
    }
}

