/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.util;

import inet.ipaddr.IPAddress;
import inet.ipaddr.format.util.AddressTrie;
import inet.ipaddr.format.util.BaseDualIPv4v6Tries;
import inet.ipaddr.ipv4.IPv4AddressTrie;
import inet.ipaddr.ipv6.IPv6AddressTrie;
import java.util.Iterator;
import java.util.Spliterator;

public class DualIPv4v6Tries
extends BaseDualIPv4v6Tries<IPv4AddressTrie, IPv6AddressTrie> {
    private static final long serialVersionUID = 1L;
    private IPv6AddressTrie ipv6Trie;
    private IPv4AddressTrie ipv4Trie;

    public DualIPv4v6Tries() {
        this(new IPv4AddressTrie(), new IPv6AddressTrie());
    }

    public DualIPv4v6Tries(IPv4AddressTrie ipv4Trie, IPv6AddressTrie ipv6Trie) {
        super(ipv4Trie, ipv6Trie);
        this.ipv4Trie = ipv4Trie;
        this.ipv6Trie = ipv6Trie;
    }

    @Override
    public IPv4AddressTrie getIPv4Trie() {
        return this.ipv4Trie;
    }

    @Override
    public IPv6AddressTrie getIPv6Trie() {
        return this.ipv6Trie;
    }

    @Override
    public DualIPv4v6Tries clone() {
        DualIPv4v6Tries result = (DualIPv4v6Tries)super.clone();
        result.ipv4Trie = this.ipv4Trie.clone();
        result.ipv6Trie = this.ipv6Trie.clone();
        result.assignTrackers(result.ipv4Trie, result.ipv6Trie);
        return result;
    }

    @Override
    public Iterator<AddressTrie.TrieNode<? extends IPAddress>> nodeIterator(boolean forward) {
        return this.combineNodeIterators(forward, this.getIPv4Trie().nodeIterator(forward), this.getIPv6Trie().nodeIterator(forward));
    }

    @Override
    public Iterator<AddressTrie.TrieNode<? extends IPAddress>> containingFirstIterator(boolean forwardSubNodeOrder) {
        return this.combineNodeIterators(forwardSubNodeOrder, this.getIPv4Trie().containingFirstIterator(forwardSubNodeOrder), this.getIPv6Trie().containingFirstIterator(forwardSubNodeOrder));
    }

    @Override
    public Iterator<AddressTrie.TrieNode<? extends IPAddress>> containedFirstIterator(boolean forwardSubNodeOrder) {
        return this.combineNodeIterators(forwardSubNodeOrder, this.getIPv4Trie().containedFirstIterator(forwardSubNodeOrder), this.getIPv6Trie().containedFirstIterator(forwardSubNodeOrder));
    }

    @Override
    public Iterator<AddressTrie.TrieNode<? extends IPAddress>> blockSizeNodeIterator(boolean lowerSubNodeFirst) {
        return this.combineBlockSizeNodeIterators(lowerSubNodeFirst, this.getIPv4Trie().blockSizeNodeIterator(lowerSubNodeFirst), this.getIPv6Trie().blockSizeNodeIterator(lowerSubNodeFirst));
    }

    @Override
    public Spliterator<AddressTrie.TrieNode<? extends IPAddress>> nodeSpliterator(boolean forward) {
        return this.combineNodeSpliterators(forward, this.getIPv4Trie().nodeSpliterator(forward), this.getIPv6Trie().nodeSpliterator(forward));
    }
}

