/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class ApplicationHistoryManagerOnTimelineStore
extends AbstractService
implements ApplicationHistoryManager {
    private static final Log LOG = LogFactory.getLog(ApplicationHistoryManagerOnTimelineStore.class);
    @VisibleForTesting
    static final String UNAVAILABLE = "N/A";
    private TimelineDataManager timelineDataManager;
    private ApplicationACLsManager aclsManager;
    private String serverHttpAddress;
    private long maxLoadedApplications;

    public ApplicationHistoryManagerOnTimelineStore(TimelineDataManager timelineDataManager, ApplicationACLsManager aclsManager) {
        super(ApplicationHistoryManagerOnTimelineStore.class.getName());
        this.timelineDataManager = timelineDataManager;
        this.aclsManager = aclsManager;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.serverHttpAddress = WebAppUtils.getHttpSchemePrefix((Configuration)conf) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)conf);
        this.maxLoadedApplications = conf.getLong("yarn.timeline-service.generic-application-history.max-applications", 10000L);
        super.serviceInit(conf);
    }

    @Override
    public ApplicationReport getApplication(ApplicationId appId) throws YarnException, IOException {
        return this.getApplication(appId, ApplicationReportField.ALL).appReport;
    }

    @Override
    public Map<ApplicationId, ApplicationReport> getApplications(long appsNum) throws YarnException, IOException {
        TimelineEntities entities = this.timelineDataManager.getEntities("YARN_APPLICATION", null, null, null, null, null, null, appsNum == Long.MAX_VALUE ? this.maxLoadedApplications : appsNum, EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        LinkedHashMap<ApplicationId, ApplicationReport> apps = new LinkedHashMap<ApplicationId, ApplicationReport>();
        if (entities != null && entities.getEntities() != null) {
            for (TimelineEntity entity : entities.getEntities()) {
                try {
                    ApplicationReportExt app = this.generateApplicationReport(entity, ApplicationReportField.ALL);
                    apps.put(app.appReport.getApplicationId(), app.appReport);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error on generating application report for " + entity.getEntityId()), (Throwable)e);
                }
            }
        }
        return apps;
    }

    @Override
    public Map<ApplicationAttemptId, ApplicationAttemptReport> getApplicationAttempts(ApplicationId appId) throws YarnException, IOException {
        ApplicationReportExt app = this.getApplication(appId, ApplicationReportField.USER_AND_ACLS);
        this.checkAccess(app);
        TimelineEntities entities = this.timelineDataManager.getEntities("YARN_APPLICATION_ATTEMPT", new NameValuePair("YARN_APPLICATION_ATTEMPT_PARENT", appId.toString()), null, null, null, null, null, Long.MAX_VALUE, EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        LinkedHashMap<ApplicationAttemptId, ApplicationAttemptReport> appAttempts = new LinkedHashMap<ApplicationAttemptId, ApplicationAttemptReport>();
        for (TimelineEntity entity : entities.getEntities()) {
            ApplicationAttemptReport appAttempt = ApplicationHistoryManagerOnTimelineStore.convertToApplicationAttemptReport(entity);
            appAttempts.put(appAttempt.getApplicationAttemptId(), appAttempt);
        }
        return appAttempts;
    }

    @Override
    public ApplicationAttemptReport getApplicationAttempt(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        return this.getApplicationAttempt(appAttemptId, true);
    }

    private ApplicationAttemptReport getApplicationAttempt(ApplicationAttemptId appAttemptId, boolean checkACLs) throws YarnException, IOException {
        TimelineEntity entity;
        if (checkACLs) {
            ApplicationReportExt app = this.getApplication(appAttemptId.getApplicationId(), ApplicationReportField.USER_AND_ACLS);
            this.checkAccess(app);
        }
        if ((entity = this.timelineDataManager.getEntity("YARN_APPLICATION_ATTEMPT", appAttemptId.toString(), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser())) == null) {
            throw new ApplicationAttemptNotFoundException("The entity for application attempt " + appAttemptId + " doesn't exist in the timeline store");
        }
        return ApplicationHistoryManagerOnTimelineStore.convertToApplicationAttemptReport(entity);
    }

    @Override
    public ContainerReport getContainer(ContainerId containerId) throws YarnException, IOException {
        ApplicationReportExt app = this.getApplication(containerId.getApplicationAttemptId().getApplicationId(), ApplicationReportField.USER_AND_ACLS);
        this.checkAccess(app);
        TimelineEntity entity = this.timelineDataManager.getEntity("YARN_CONTAINER", containerId.toString(), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        if (entity == null) {
            throw new ContainerNotFoundException("The entity for container " + containerId + " doesn't exist in the timeline store");
        }
        return ApplicationHistoryManagerOnTimelineStore.convertToContainerReport(entity, this.serverHttpAddress, app.appReport.getUser());
    }

    @Override
    public ContainerReport getAMContainer(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        ApplicationAttemptReport appAttempt = this.getApplicationAttempt(appAttemptId, false);
        return this.getContainer(appAttempt.getAMContainerId());
    }

    @Override
    public Map<ContainerId, ContainerReport> getContainers(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        ApplicationReportExt app = this.getApplication(appAttemptId.getApplicationId(), ApplicationReportField.USER_AND_ACLS);
        this.checkAccess(app);
        TimelineEntities entities = this.timelineDataManager.getEntities("YARN_CONTAINER", new NameValuePair("YARN_CONTAINER_PARENT", appAttemptId.toString()), null, null, null, null, null, Long.MAX_VALUE, EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        LinkedHashMap<ContainerId, ContainerReport> containers = new LinkedHashMap<ContainerId, ContainerReport>();
        if (entities != null && entities.getEntities() != null) {
            for (TimelineEntity entity : entities.getEntities()) {
                ContainerReport container = ApplicationHistoryManagerOnTimelineStore.convertToContainerReport(entity, this.serverHttpAddress, app.appReport.getUser());
                containers.put(container.getContainerId(), container);
            }
        }
        return containers;
    }

    private static ApplicationReportExt convertToApplicationReport(TimelineEntity entity, ApplicationReportField field) {
        List events;
        String user = null;
        String queue = null;
        String name = null;
        String type = null;
        long createdTime = 0L;
        long finishedTime = 0L;
        ApplicationAttemptId latestApplicationAttemptId = null;
        String diagnosticsInfo = null;
        FinalApplicationStatus finalStatus = FinalApplicationStatus.UNDEFINED;
        YarnApplicationState state = null;
        ApplicationResourceUsageReport appResources = null;
        HashMap<ApplicationAccessType, String> appViewACLs = new HashMap<ApplicationAccessType, String>();
        Map entityInfo = entity.getOtherInfo();
        if (entityInfo != null) {
            String appViewACLsStr;
            if (entityInfo.containsKey("YARN_APPLICATION_USER")) {
                user = entityInfo.get("YARN_APPLICATION_USER").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_VIEW_ACLS") && (appViewACLsStr = entityInfo.get("YARN_APPLICATION_VIEW_ACLS").toString()).length() > 0) {
                appViewACLs.put(ApplicationAccessType.VIEW_APP, appViewACLsStr);
            }
            if (field == ApplicationReportField.USER_AND_ACLS) {
                return new ApplicationReportExt(ApplicationReport.newInstance((ApplicationId)ConverterUtils.toApplicationId((String)entity.getEntityId()), latestApplicationAttemptId, (String)user, (String)queue, (String)name, null, (int)-1, null, state, diagnosticsInfo, null, (long)createdTime, (long)finishedTime, (FinalApplicationStatus)finalStatus, null, null, (float)1.0f, (String)type, null), appViewACLs);
            }
            if (entityInfo.containsKey("YARN_APPLICATION_QUEUE")) {
                queue = entityInfo.get("YARN_APPLICATION_QUEUE").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_NAME")) {
                name = entityInfo.get("YARN_APPLICATION_NAME").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_TYPE")) {
                type = entityInfo.get("YARN_APPLICATION_TYPE").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_CPU_METRIC")) {
                long vcoreSeconds = Long.parseLong(entityInfo.get("YARN_APPLICATION_CPU_METRIC").toString());
                long memorySeconds = Long.parseLong(entityInfo.get("YARN_APPLICATION_MEM_METRIC").toString());
                appResources = ApplicationResourceUsageReport.newInstance((int)0, (int)0, null, null, null, (long)memorySeconds, (long)vcoreSeconds);
            }
        }
        if ((events = entity.getEvents()) != null) {
            for (TimelineEvent event : events) {
                if (event.getEventType().equals("YARN_APPLICATION_CREATED")) {
                    createdTime = event.getTimestamp();
                    continue;
                }
                if (!event.getEventType().equals("YARN_APPLICATION_FINISHED")) continue;
                finishedTime = event.getTimestamp();
                Map eventInfo = event.getEventInfo();
                if (eventInfo == null) continue;
                if (eventInfo.containsKey("YARN_APPLICATION_LATEST_APP_ATTEMPT")) {
                    latestApplicationAttemptId = ConverterUtils.toApplicationAttemptId((String)eventInfo.get("YARN_APPLICATION_LATEST_APP_ATTEMPT").toString());
                }
                if (eventInfo.containsKey("YARN_APPLICATION_DIAGNOSTICS_INFO")) {
                    diagnosticsInfo = eventInfo.get("YARN_APPLICATION_DIAGNOSTICS_INFO").toString();
                }
                if (eventInfo.containsKey("YARN_APPLICATION_FINAL_STATUS")) {
                    finalStatus = FinalApplicationStatus.valueOf((String)eventInfo.get("YARN_APPLICATION_FINAL_STATUS").toString());
                }
                if (!eventInfo.containsKey("YARN_APPLICATION_STATE")) continue;
                state = YarnApplicationState.valueOf((String)eventInfo.get("YARN_APPLICATION_STATE").toString());
            }
        }
        return new ApplicationReportExt(ApplicationReport.newInstance((ApplicationId)ConverterUtils.toApplicationId((String)entity.getEntityId()), latestApplicationAttemptId, (String)user, (String)queue, (String)name, null, (int)-1, null, state, diagnosticsInfo, null, (long)createdTime, (long)finishedTime, (FinalApplicationStatus)finalStatus, appResources, null, (float)1.0f, (String)type, null), appViewACLs);
    }

    private static ApplicationAttemptReport convertToApplicationAttemptReport(TimelineEntity entity) {
        String host = null;
        int rpcPort = -1;
        ContainerId amContainerId = null;
        String trackingUrl = null;
        String originalTrackingUrl = null;
        String diagnosticsInfo = null;
        YarnApplicationAttemptState state = null;
        List events = entity.getEvents();
        if (events != null) {
            for (TimelineEvent event : events) {
                Map eventInfo;
                if (event.getEventType().equals("YARN_APPLICATION_ATTEMPT_REGISTERED")) {
                    eventInfo = event.getEventInfo();
                    if (eventInfo == null) continue;
                    if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_HOST")) {
                        host = eventInfo.get("YARN_APPLICATION_ATTEMPT_HOST").toString();
                    }
                    if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_RPC_PORT")) {
                        rpcPort = (Integer)eventInfo.get("YARN_APPLICATION_ATTEMPT_RPC_PORT");
                    }
                    if (!eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER")) continue;
                    amContainerId = ConverterUtils.toContainerId((String)eventInfo.get("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER").toString());
                    continue;
                }
                if (!event.getEventType().equals("YARN_APPLICATION_ATTEMPT_FINISHED") || (eventInfo = event.getEventInfo()) == null) continue;
                if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_TRACKING_URL")) {
                    trackingUrl = eventInfo.get("YARN_APPLICATION_ATTEMPT_TRACKING_URL").toString();
                }
                if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL")) {
                    originalTrackingUrl = eventInfo.get("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL").toString();
                }
                if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO")) {
                    diagnosticsInfo = eventInfo.get("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO").toString();
                }
                if (!eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_STATE")) continue;
                state = YarnApplicationAttemptState.valueOf((String)eventInfo.get("YARN_APPLICATION_ATTEMPT_STATE").toString());
            }
        }
        return ApplicationAttemptReport.newInstance((ApplicationAttemptId)ConverterUtils.toApplicationAttemptId((String)entity.getEntityId()), host, (int)rpcPort, trackingUrl, originalTrackingUrl, diagnosticsInfo, state, amContainerId);
    }

    private static ContainerReport convertToContainerReport(TimelineEntity entity, String serverHttpAddress, String user) {
        List events;
        int allocatedMem = 0;
        int allocatedVcore = 0;
        String allocatedHost = null;
        int allocatedPort = -1;
        int allocatedPriority = 0;
        long createdTime = 0L;
        long finishedTime = 0L;
        String diagnosticsInfo = null;
        int exitStatus = -1000;
        ContainerState state = null;
        String nodeHttpAddress = null;
        Map entityInfo = entity.getOtherInfo();
        if (entityInfo != null) {
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_MEMORY")) {
                allocatedMem = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_MEMORY");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_VCORE")) {
                allocatedVcore = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_VCORE");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_HOST")) {
                allocatedHost = entityInfo.get("YARN_CONTAINER_ALLOCATED_HOST").toString();
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_PORT")) {
                allocatedPort = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_PORT");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_PRIORITY")) {
                allocatedPriority = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_PRIORITY");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS")) {
                nodeHttpAddress = (String)entityInfo.get("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS");
            }
        }
        if ((events = entity.getEvents()) != null) {
            for (TimelineEvent event : events) {
                if (event.getEventType().equals("YARN_CONTAINER_CREATED")) {
                    createdTime = event.getTimestamp();
                    continue;
                }
                if (!event.getEventType().equals("YARN_CONTAINER_FINISHED")) continue;
                finishedTime = event.getTimestamp();
                Map eventInfo = event.getEventInfo();
                if (eventInfo == null) continue;
                if (eventInfo.containsKey("YARN_CONTAINER_DIAGNOSTICS_INFO")) {
                    diagnosticsInfo = eventInfo.get("YARN_CONTAINER_DIAGNOSTICS_INFO").toString();
                }
                if (eventInfo.containsKey("YARN_CONTAINER_EXIT_STATUS")) {
                    exitStatus = (Integer)eventInfo.get("YARN_CONTAINER_EXIT_STATUS");
                }
                if (!eventInfo.containsKey("YARN_CONTAINER_STATE")) continue;
                state = ContainerState.valueOf((String)eventInfo.get("YARN_CONTAINER_STATE").toString());
            }
        }
        NodeId allocatedNode = NodeId.newInstance(allocatedHost, (int)allocatedPort);
        ContainerId containerId = ConverterUtils.toContainerId((String)entity.getEntityId());
        String logUrl = WebAppUtils.getAggregatedLogURL((String)serverHttpAddress, (String)allocatedNode.toString(), (String)containerId.toString(), (String)containerId.toString(), (String)user);
        return ContainerReport.newInstance((ContainerId)ConverterUtils.toContainerId((String)entity.getEntityId()), (Resource)Resource.newInstance((int)allocatedMem, (int)allocatedVcore), (NodeId)NodeId.newInstance((String)allocatedHost, (int)allocatedPort), (Priority)Priority.newInstance((int)allocatedPriority), (long)createdTime, (long)finishedTime, (String)diagnosticsInfo, (String)logUrl, (int)exitStatus, state, (String)nodeHttpAddress);
    }

    private ApplicationReportExt generateApplicationReport(TimelineEntity entity, ApplicationReportField field) throws YarnException, IOException {
        ApplicationReportExt app = ApplicationHistoryManagerOnTimelineStore.convertToApplicationReport(entity, field);
        if (field == ApplicationReportField.USER_AND_ACLS) {
            return app;
        }
        try {
            this.checkAccess(app);
            if (app.appReport.getCurrentApplicationAttemptId() != null) {
                ApplicationAttemptReport appAttempt = this.getApplicationAttempt(app.appReport.getCurrentApplicationAttemptId(), false);
                app.appReport.setHost(appAttempt.getHost());
                app.appReport.setRpcPort(appAttempt.getRpcPort());
                app.appReport.setTrackingUrl(appAttempt.getTrackingUrl());
                app.appReport.setOriginalTrackingUrl(appAttempt.getOriginalTrackingUrl());
            }
        }
        catch (AuthorizationException | ApplicationAttemptNotFoundException e) {
            app.appReport.setDiagnostics(null);
            app.appReport.setCurrentApplicationAttemptId(null);
        }
        if (app.appReport.getCurrentApplicationAttemptId() == null) {
            app.appReport.setCurrentApplicationAttemptId(ApplicationAttemptId.newInstance((ApplicationId)app.appReport.getApplicationId(), (int)-1));
        }
        if (app.appReport.getHost() == null) {
            app.appReport.setHost(UNAVAILABLE);
        }
        if (app.appReport.getRpcPort() < 0) {
            app.appReport.setRpcPort(-1);
        }
        if (app.appReport.getTrackingUrl() == null) {
            app.appReport.setTrackingUrl(UNAVAILABLE);
        }
        if (app.appReport.getOriginalTrackingUrl() == null) {
            app.appReport.setOriginalTrackingUrl(UNAVAILABLE);
        }
        if (app.appReport.getDiagnostics() == null) {
            app.appReport.setDiagnostics("");
        }
        return app;
    }

    private ApplicationReportExt getApplication(ApplicationId appId, ApplicationReportField field) throws YarnException, IOException {
        TimelineEntity entity = this.timelineDataManager.getEntity("YARN_APPLICATION", appId.toString(), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        if (entity == null) {
            throw new ApplicationNotFoundException("The entity for application " + appId + " doesn't exist in the timeline store");
        }
        return this.generateApplicationReport(entity, field);
    }

    private void checkAccess(ApplicationReportExt app) throws YarnException, IOException {
        if (app.appViewACLs != null) {
            this.aclsManager.addApplication(app.appReport.getApplicationId(), app.appViewACLs);
            try {
                if (!this.aclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, app.appReport.getUser(), app.appReport.getApplicationId())) {
                    throw new AuthorizationException("User " + UserGroupInformation.getCurrentUser().getShortUserName() + " does not have privilage to see this application " + app.appReport.getApplicationId());
                }
            }
            finally {
                this.aclsManager.removeApplication(app.appReport.getApplicationId());
            }
        }
    }

    private static class ApplicationReportExt {
        private ApplicationReport appReport;
        private Map<ApplicationAccessType, String> appViewACLs;

        public ApplicationReportExt(ApplicationReport appReport, Map<ApplicationAccessType, String> appViewACLs) {
            this.appReport = appReport;
            this.appViewACLs = appViewACLs;
        }
    }

    private static enum ApplicationReportField {
        ALL,
        USER_AND_ACLS;

    }
}

