/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.sort.hilbert;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.shade.org.davidmoten.hilbert.HilbertCurve;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.types.VariantType;
import org.apache.paimon.utils.ConvertBinaryUtil;
import org.apache.paimon.utils.Preconditions;

public class HilbertIndexer
implements Serializable {
    private static final long PRIMITIVE_EMPTY = Long.MAX_VALUE;
    private static final int BITS_NUM = 63;
    private final Set<RowProcessor> functionSet;
    private final int[] fieldsIndex;

    public HilbertIndexer(RowType rowType, List<String> orderColumns) {
        Preconditions.checkArgument((orderColumns.size() > 1 ? 1 : 0) != 0, (Object)"Hilbert sort needs at least two columns.");
        List fields = rowType.getFieldNames();
        this.fieldsIndex = new int[orderColumns.size()];
        for (int i = 0; i < this.fieldsIndex.length; ++i) {
            int index = fields.indexOf(orderColumns.get(i));
            if (index == -1) {
                throw new IllegalArgumentException("Can't find column: " + orderColumns.get(i) + " in row type fields: " + fields);
            }
            this.fieldsIndex[i] = index;
        }
        this.functionSet = this.constructFunctionMap(rowType.getFields());
    }

    public void open() {
        this.functionSet.forEach(RowProcessor::open);
    }

    public byte[] index(InternalRow row) {
        Long[] columnLongs = new Long[this.fieldsIndex.length];
        int index = 0;
        for (RowProcessor f : this.functionSet) {
            columnLongs[index++] = f.hilbertValue(row);
        }
        return HilbertIndexer.hilbertCurvePosBytes(columnLongs);
    }

    public Set<RowProcessor> constructFunctionMap(List<DataField> fields) {
        LinkedHashSet<RowProcessor> hilbertFunctionSet = new LinkedHashSet<RowProcessor>();
        for (int index : this.fieldsIndex) {
            DataField field = fields.get(index);
            hilbertFunctionSet.add(HilbertIndexer.hmapColumnToCalculator(field, index));
        }
        return hilbertFunctionSet;
    }

    public static RowProcessor hmapColumnToCalculator(DataField field, int index) {
        DataType type = field.type();
        return new RowProcessor((HProcessFunction)type.accept((DataTypeVisitor)new TypeVisitor(index)));
    }

    public static byte[] hilbertCurvePosBytes(Long[] points) {
        long[] data = Arrays.stream(points).mapToLong(Long::longValue).toArray();
        HilbertCurve hilbertCurve = HilbertCurve.bits(63).dimensions(points.length);
        BigInteger index = hilbertCurve.index(data);
        return ConvertBinaryUtil.paddingToNByte(index.toByteArray(), 63);
    }

    public static interface HProcessFunction
    extends Function<InternalRow, Long>,
    Serializable {
    }

    public static class RowProcessor
    implements Serializable {
        private final HProcessFunction process;

        public RowProcessor(HProcessFunction process) {
            this.process = process;
        }

        public void open() {
        }

        public Long hilbertValue(InternalRow o) {
            return (Long)this.process.apply(o);
        }
    }

    public static class TypeVisitor
    implements DataTypeVisitor<HProcessFunction>,
    Serializable {
        private final int fieldIndex;

        public TypeVisitor(int index) {
            this.fieldIndex = index;
        }

        public HProcessFunction visit(CharType charType) {
            return row -> {
                if (row.isNullAt(this.fieldIndex)) {
                    return Long.MAX_VALUE;
                }
                BinaryString binaryString = row.getString(this.fieldIndex);
                return ConvertBinaryUtil.convertBytesToLong(binaryString.toBytes());
            };
        }

        public HProcessFunction visit(VarCharType varCharType) {
            return row -> {
                if (row.isNullAt(this.fieldIndex)) {
                    return Long.MAX_VALUE;
                }
                BinaryString binaryString = row.getString(this.fieldIndex);
                return ConvertBinaryUtil.convertBytesToLong(binaryString.toBytes());
            };
        }

        public HProcessFunction visit(BooleanType booleanType) {
            return row -> {
                if (row.isNullAt(this.fieldIndex)) {
                    return Long.MAX_VALUE;
                }
                return row.getBoolean(this.fieldIndex) ? Long.MAX_VALUE : 0L;
            };
        }

        public HProcessFunction visit(BinaryType binaryType) {
            return row -> row.isNullAt(this.fieldIndex) ? Long.MAX_VALUE : ConvertBinaryUtil.convertBytesToLong(row.getBinary(this.fieldIndex));
        }

        public HProcessFunction visit(VarBinaryType varBinaryType) {
            return row -> row.isNullAt(this.fieldIndex) ? Long.MAX_VALUE : ConvertBinaryUtil.convertBytesToLong(row.getBinary(this.fieldIndex));
        }

        public HProcessFunction visit(DecimalType decimalType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter((DataType)decimalType, this.fieldIndex);
            return row -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? Long.MAX_VALUE : ((Decimal)o).toBigDecimal().longValue();
            };
        }

        public HProcessFunction visit(TinyIntType tinyIntType) {
            return row -> row.isNullAt(this.fieldIndex) ? Long.MAX_VALUE : ConvertBinaryUtil.convertBytesToLong(new byte[]{row.getByte(this.fieldIndex)});
        }

        public HProcessFunction visit(SmallIntType smallIntType) {
            return row -> row.isNullAt(this.fieldIndex) ? Long.MAX_VALUE : (long)row.getShort(this.fieldIndex);
        }

        public HProcessFunction visit(IntType intType) {
            return row -> row.isNullAt(this.fieldIndex) ? Long.MAX_VALUE : (long)row.getInt(this.fieldIndex);
        }

        public HProcessFunction visit(BigIntType bigIntType) {
            return row -> row.isNullAt(this.fieldIndex) ? Long.MAX_VALUE : row.getLong(this.fieldIndex);
        }

        public HProcessFunction visit(FloatType floatType) {
            return row -> row.isNullAt(this.fieldIndex) ? Long.MAX_VALUE : Double.doubleToLongBits(row.getFloat(this.fieldIndex));
        }

        public HProcessFunction visit(DoubleType doubleType) {
            return row -> row.isNullAt(this.fieldIndex) ? Long.MAX_VALUE : Double.doubleToLongBits(row.getDouble(this.fieldIndex));
        }

        public HProcessFunction visit(DateType dateType) {
            return row -> row.isNullAt(this.fieldIndex) ? Long.MAX_VALUE : (long)row.getInt(this.fieldIndex);
        }

        public HProcessFunction visit(TimeType timeType) {
            return row -> row.isNullAt(this.fieldIndex) ? Long.MAX_VALUE : (long)row.getInt(this.fieldIndex);
        }

        public HProcessFunction visit(TimestampType timestampType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter((DataType)timestampType, this.fieldIndex);
            return row -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? Long.MAX_VALUE : ((Timestamp)o).getMillisecond();
            };
        }

        public HProcessFunction visit(LocalZonedTimestampType localZonedTimestampType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter((DataType)localZonedTimestampType, this.fieldIndex);
            return row -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? Long.MAX_VALUE : ((Timestamp)o).getMillisecond();
            };
        }

        public HProcessFunction visit(VariantType variantType) {
            throw new RuntimeException("Unsupported type");
        }

        public HProcessFunction visit(ArrayType arrayType) {
            throw new RuntimeException("Unsupported type");
        }

        public HProcessFunction visit(MultisetType multisetType) {
            throw new RuntimeException("Unsupported type");
        }

        public HProcessFunction visit(MapType mapType) {
            throw new RuntimeException("Unsupported type");
        }

        public HProcessFunction visit(RowType rowType) {
            throw new RuntimeException("Unsupported type");
        }
    }
}

