/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.ModelEntity;
import org.apache.gravitino.meta.NamespacedEntityId;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.ModelMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionAliasRelMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionMetaMapper;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.PolicyMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.mapper.SecurableObjectMapper;
import org.apache.gravitino.storage.relational.mapper.StatisticMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.po.ModelPO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelMetaService {
    private static final Logger LOG;
    private static final ModelMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ Annotation ajc$anno$8;

    public static ModelMetaService getInstance() {
        return INSTANCE;
    }

    private ModelMetaService() {
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listModelsByNamespace")
    public List<ModelEntity> listModelsByNamespace(Namespace ns) {
        Namespace namespace = ns;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)namespace);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = ModelMetaService.class.getDeclaredMethod("listModelsByNamespace", Namespace.class).getAnnotation(Monitored.class);
        }
        return (List)ModelMetaService.listModelsByNamespace_aroundBody1$advice(this, namespace, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getModelByIdentifier")
    public ModelEntity getModelByIdentifier(NameIdentifier ident) {
        NameIdentifier nameIdentifier = ident;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = ModelMetaService.class.getDeclaredMethod("getModelByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (ModelEntity)ModelMetaService.getModelByIdentifier_aroundBody3$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertModel")
    public void insertModel(ModelEntity modelEntity, boolean overwrite) throws IOException {
        ModelEntity modelEntity2 = modelEntity;
        boolean bl = overwrite;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)modelEntity2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = ModelMetaService.class.getDeclaredMethod("insertModel", ModelEntity.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        ModelMetaService.insertModel_aroundBody5$advice(this, modelEntity2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteModel")
    public boolean deleteModel(NameIdentifier ident) {
        NameIdentifier nameIdentifier = ident;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = ModelMetaService.class.getDeclaredMethod("deleteModel", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)ModelMetaService.deleteModel_aroundBody7$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteModelMetasByLegacyTimeline")
    public int deleteModelMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        Long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)l, (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = ModelMetaService.class.getDeclaredMethod("deleteModelMetasByLegacyTimeline", Long.class, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)ModelMetaService.deleteModelMetasByLegacyTimeline_aroundBody9$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getModelIdBySchemaIdAndModelName")
    public Long getModelIdBySchemaIdAndModelName(Long schemaId, String modelName) {
        Long l = schemaId;
        String string = modelName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)l, (Object)string);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = ModelMetaService.class.getDeclaredMethod("getModelIdBySchemaIdAndModelName", Long.class, String.class).getAnnotation(Monitored.class);
        }
        return (Long)ModelMetaService.getModelIdBySchemaIdAndModelName_aroundBody11$advice(this, l, string, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getModelPOById")
    ModelPO getModelPOById(Long modelId) {
        Long l = modelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)l);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = ModelMetaService.class.getDeclaredMethod("getModelPOById", Long.class).getAnnotation(Monitored.class);
        }
        return (ModelPO)ModelMetaService.getModelPOById_aroundBody13$advice(this, l, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    private void fillModelPOBuilderParentEntityId(ModelPO.Builder builder, Namespace ns) {
        NamespaceUtil.checkModel(ns);
        NamespacedEntityId namespacedEntityId = EntityIdService.getEntityIds(NameIdentifier.of((String[])ns.levels()), Entity.EntityType.SCHEMA);
        builder.withMetalakeId(namespacedEntityId.namespaceIds()[0]);
        builder.withCatalogId(namespacedEntityId.namespaceIds()[1]);
        builder.withSchemaId(namespacedEntityId.entityId());
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getModelPOByIdentifier")
    ModelPO getModelPOByIdentifier(NameIdentifier ident) {
        NameIdentifier nameIdentifier = ident;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = ModelMetaService.class.getDeclaredMethod("getModelPOByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (ModelPO)ModelMetaService.getModelPOByIdentifier_aroundBody15$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updateModel")
    public <E extends Entity & HasIdentifier> ModelEntity updateModel(NameIdentifier identifier, Function<E, E> updater) throws IOException {
        NameIdentifier nameIdentifier = identifier;
        Function<E, E> function = updater;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)nameIdentifier, function);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = ModelMetaService.class.getDeclaredMethod("updateModel", NameIdentifier.class, Function.class).getAnnotation(Monitored.class);
        }
        return (ModelEntity)ModelMetaService.updateModel_aroundBody17$advice(this, nameIdentifier, function, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    static {
        ModelMetaService.ajc$preClinit();
        LOG = LoggerFactory.getLogger(ModelMetaService.class);
        INSTANCE = new ModelMetaService();
    }

    private static final /* synthetic */ List listModelsByNamespace_aroundBody0(ModelMetaService ajc$this, Namespace ns, JoinPoint joinPoint) {
        NamespaceUtil.checkModel(ns);
        Long schemaId = EntityIdService.getEntityId(NameIdentifier.of((String[])ns.levels()), Entity.EntityType.SCHEMA);
        List modelPOs = SessionUtils.getWithoutCommit(ModelMetaMapper.class, mapper -> mapper.listModelPOsBySchemaId(schemaId));
        return modelPOs.stream().map(m -> POConverters.fromModelPO(m, ns)).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listModelsByNamespace_aroundBody1$advice(ModelMetaService ajc$this, Namespace ns, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelMetaService.listModelsByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelMetaService.listModelsByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = ModelMetaService.listModelsByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ ModelEntity getModelByIdentifier_aroundBody2(ModelMetaService ajc$this, NameIdentifier ident, JoinPoint joinPoint) {
        ModelPO modelPO = ajc$this.getModelPOByIdentifier(ident);
        return POConverters.fromModelPO(modelPO, ident.namespace());
    }

    private static final /* synthetic */ Object getModelByIdentifier_aroundBody3$advice(ModelMetaService ajc$this, NameIdentifier ident, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        ModelEntity modelEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelMetaService.getModelByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelMetaService.getModelByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ModelEntity result = ModelMetaService.getModelByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                modelEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return modelEntity;
    }

    private static final /* synthetic */ void insertModel_aroundBody4(ModelMetaService ajc$this, ModelEntity modelEntity, boolean overwrite, JoinPoint joinPoint) {
        NameIdentifierUtil.checkModel(modelEntity.nameIdentifier());
        try {
            ModelPO.Builder builder = ModelPO.builder();
            ajc$this.fillModelPOBuilderParentEntityId(builder, modelEntity.namespace());
            SessionUtils.doWithCommit(ModelMetaMapper.class, mapper -> {
                ModelPO po = POConverters.initializeModelPO(modelEntity, builder);
                if (overwrite) {
                    mapper.insertModelMetaOnDuplicateKeyUpdate(po);
                } else {
                    mapper.insertModelMeta(po);
                }
            });
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.MODEL, modelEntity.nameIdentifier().toString());
            throw re;
        }
    }

    private static final /* synthetic */ Object insertModel_aroundBody5$advice(ModelMetaService ajc$this, ModelEntity modelEntity, boolean overwrite, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ModelMetaService.insertModel_aroundBody4(ajc$this, modelEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ModelMetaService.insertModel_aroundBody4(ajc$this, modelEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ModelMetaService.insertModel_aroundBody4(ajc$this, modelEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ boolean deleteModel_aroundBody6(ModelMetaService ajc$this, NameIdentifier ident, JoinPoint joinPoint) {
        Long modelId;
        Long schemaId;
        NameIdentifierUtil.checkModel(ident);
        try {
            schemaId = EntityIdService.getEntityId(NameIdentifier.of((String[])ident.namespace().levels()), Entity.EntityType.SCHEMA);
            modelId = ajc$this.getModelIdBySchemaIdAndModelName(schemaId, ident.name());
        }
        catch (NoSuchEntityException e) {
            LOG.warn("Failed to delete model: {}", (Object)ident, (Object)e);
            return false;
        }
        AtomicInteger modelDeletedCount = new AtomicInteger();
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.softDeleteModelVersionsBySchemaIdAndModelName(schemaId, ident.name())), () -> SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.softDeleteModelVersionAliasRelsBySchemaIdAndModelName(schemaId, ident.name())), () -> modelDeletedCount.set(SessionUtils.getWithoutCommit(ModelMetaMapper.class, mapper -> mapper.softDeleteModelMetaBySchemaIdAndModelName(schemaId, ident.name()))), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetadataObjectIdAndType(modelId, MetadataObject.Type.MODEL.name())), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteObjectRelsByMetadataObject(modelId, MetadataObject.Type.MODEL.name())), () -> SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByMetadataObject(modelId, MetadataObject.Type.MODEL.name())), () -> SessionUtils.doWithoutCommit(StatisticMetaMapper.class, mapper -> mapper.softDeleteStatisticsByEntityId(modelId)), () -> SessionUtils.doWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.softDeletePolicyMetadataObjectRelsByMetadataObject(modelId, MetadataObject.Type.MODEL.name())));
        return modelDeletedCount.get() > 0;
    }

    private static final /* synthetic */ Object deleteModel_aroundBody7$advice(ModelMetaService ajc$this, NameIdentifier ident, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)ModelMetaService.deleteModel_aroundBody6(ajc$this, ident, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)ModelMetaService.deleteModel_aroundBody6(ajc$this, ident, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)ModelMetaService.deleteModel_aroundBody6(ajc$this, ident, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deleteModelMetasByLegacyTimeline_aroundBody8(ModelMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint joinPoint) {
        return SessionUtils.doWithCommitAndFetchResult(ModelMetaMapper.class, mapper -> mapper.deleteModelMetasByLegacyTimeline(legacyTimeline, limit));
    }

    private static final /* synthetic */ Object deleteModelMetasByLegacyTimeline_aroundBody9$advice(ModelMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)ModelMetaService.deleteModelMetasByLegacyTimeline_aroundBody8(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)ModelMetaService.deleteModelMetasByLegacyTimeline_aroundBody8(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)ModelMetaService.deleteModelMetasByLegacyTimeline_aroundBody8(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ Long getModelIdBySchemaIdAndModelName_aroundBody10(ModelMetaService ajc$this, Long schemaId, String modelName, JoinPoint joinPoint) {
        Long modelId = SessionUtils.getWithoutCommit(ModelMetaMapper.class, mapper -> mapper.selectModelIdBySchemaIdAndModelName(schemaId, modelName));
        if (modelId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.MODEL.name().toLowerCase(Locale.ROOT), modelName});
        }
        return modelId;
    }

    private static final /* synthetic */ Object getModelIdBySchemaIdAndModelName_aroundBody11$advice(ModelMetaService ajc$this, Long schemaId, String modelName, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Long l;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelMetaService.getModelIdBySchemaIdAndModelName_aroundBody10(ajc$this, schemaId, modelName, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelMetaService.getModelIdBySchemaIdAndModelName_aroundBody10(ajc$this, schemaId, modelName, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Long result = ModelMetaService.getModelIdBySchemaIdAndModelName_aroundBody10(ajc$this, schemaId, modelName, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                l = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return l;
    }

    private static final /* synthetic */ ModelPO getModelPOById_aroundBody12(ModelMetaService ajc$this, Long modelId, JoinPoint joinPoint) {
        ModelPO modelPO = SessionUtils.getWithoutCommit(ModelMetaMapper.class, mapper -> mapper.selectModelMetaByModelId(modelId));
        if (modelPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.MODEL.name().toLowerCase(Locale.ROOT), modelId.toString()});
        }
        return modelPO;
    }

    private static final /* synthetic */ Object getModelPOById_aroundBody13$advice(ModelMetaService ajc$this, Long modelId, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        ModelPO modelPO;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelMetaService.getModelPOById_aroundBody12(ajc$this, modelId, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelMetaService.getModelPOById_aroundBody12(ajc$this, modelId, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ModelPO result = ModelMetaService.getModelPOById_aroundBody12(ajc$this, modelId, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                modelPO = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return modelPO;
    }

    private static final /* synthetic */ ModelPO getModelPOByIdentifier_aroundBody14(ModelMetaService ajc$this, NameIdentifier ident, JoinPoint joinPoint) {
        NameIdentifierUtil.checkModel(ident);
        Long schemaId = EntityIdService.getEntityId(NameIdentifier.of((String[])ident.namespace().levels()), Entity.EntityType.SCHEMA);
        ModelPO modelPO = SessionUtils.getWithoutCommit(ModelMetaMapper.class, mapper -> mapper.selectModelMetaBySchemaIdAndModelName(schemaId, ident.name()));
        if (modelPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.MODEL.name().toLowerCase(Locale.ROOT), ident.toString()});
        }
        return modelPO;
    }

    private static final /* synthetic */ Object getModelPOByIdentifier_aroundBody15$advice(ModelMetaService ajc$this, NameIdentifier ident, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        ModelPO modelPO;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelMetaService.getModelPOByIdentifier_aroundBody14(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelMetaService.getModelPOByIdentifier_aroundBody14(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ModelPO result = ModelMetaService.getModelPOByIdentifier_aroundBody14(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                modelPO = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return modelPO;
    }

    private static final /* synthetic */ ModelEntity updateModel_aroundBody16(ModelMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint joinPoint) {
        Integer updateResult;
        NameIdentifierUtil.checkModel(identifier);
        ModelPO oldModelPO = ajc$this.getModelPOByIdentifier(identifier);
        ModelEntity oldModelEntity = POConverters.fromModelPO(oldModelPO, identifier.namespace());
        ModelEntity newEntity = (ModelEntity)updater.apply(oldModelEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldModelEntity.id(), newEntity.id()), (String)"The updated model entity id: %s should be same with the table entity id before: %s", (Object)newEntity.id(), (Object)oldModelEntity.id());
        try {
            updateResult = SessionUtils.doWithCommitAndFetchResult(ModelMetaMapper.class, mapper -> mapper.updateModelMeta(POConverters.updateModelPO(oldModelPO, newEntity), oldModelPO));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.MODEL, newEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return newEntity;
        }
        throw new IOException("Failed to update the entity: " + String.valueOf(identifier));
    }

    private static final /* synthetic */ Object updateModel_aroundBody17$advice(ModelMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        ModelEntity modelEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelMetaService.updateModel_aroundBody16(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelMetaService.updateModel_aroundBody16(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ModelEntity result = ModelMetaService.updateModel_aroundBody16(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                modelEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return modelEntity;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ModelMetaService.java", ModelMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listModelsByNamespace", "org.apache.gravitino.storage.relational.service.ModelMetaService", "org.apache.gravitino.Namespace", "ns", "", "java.util.List"), 74);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getModelByIdentifier", "org.apache.gravitino.storage.relational.service.ModelMetaService", "org.apache.gravitino.NameIdentifier", "ident", "", "org.apache.gravitino.meta.ModelEntity"), 90);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertModel", "org.apache.gravitino.storage.relational.service.ModelMetaService", "org.apache.gravitino.meta.ModelEntity:boolean", "modelEntity:overwrite", "java.io.IOException", "void"), 96);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteModel", "org.apache.gravitino.storage.relational.service.ModelMetaService", "org.apache.gravitino.NameIdentifier", "ident", "", "boolean"), 121);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteModelMetasByLegacyTimeline", "org.apache.gravitino.storage.relational.service.ModelMetaService", "java.lang.Long:int", "legacyTimeline:limit", "", "int"), 195);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getModelIdBySchemaIdAndModelName", "org.apache.gravitino.storage.relational.service.ModelMetaService", "java.lang.Long:java.lang.String", "schemaId:modelName", "", "java.lang.Long"), 204);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getModelPOById", "org.apache.gravitino.storage.relational.service.ModelMetaService", "java.lang.Long", "modelId", "", "org.apache.gravitino.storage.relational.po.ModelPO"), 223);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getModelPOByIdentifier", "org.apache.gravitino.storage.relational.service.ModelMetaService", "org.apache.gravitino.NameIdentifier", "ident", "", "org.apache.gravitino.storage.relational.po.ModelPO"), 250);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateModel", "org.apache.gravitino.storage.relational.service.ModelMetaService", "org.apache.gravitino.NameIdentifier:java.util.function.Function", "identifier:updater", "java.io.IOException", "org.apache.gravitino.meta.ModelEntity"), 273);
    }
}

