/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.utils.ObjectSerializer;

public class IdentifierSerializer
extends ObjectSerializer<Identifier> {
    public IdentifierSerializer() {
        super(Identifier.SCHEMA);
    }

    @Override
    public InternalRow toRow(Identifier record) {
        return GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)record.getDatabaseName()), BinaryString.fromString((String)record.getObjectName())});
    }

    @Override
    public Identifier fromRow(InternalRow rowData) {
        String databaseName = rowData.isNullAt(0) ? null : rowData.getString(0).toString();
        String tableName = rowData.isNullAt(1) ? null : rowData.getString(1).toString();
        return Identifier.create((String)databaseName, (String)tableName);
    }
}

