/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.fileindex.FileIndexOptions;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileIndexWriter;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.FileWriterContext;
import org.apache.paimon.io.StatsCollectingSingleFileWriter;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.stats.SimpleStatsConverter;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyValueDataFileWriter
extends StatsCollectingSingleFileWriter<KeyValue, DataFileMeta> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueDataFileWriter.class);
    protected final RowType keyType;
    protected final RowType valueType;
    private final long schemaId;
    private final int level;
    private final SimpleStatsConverter keyStatsConverter;
    private final boolean isExternalPath;
    private final SimpleStatsConverter valueStatsConverter;
    private final InternalRowSerializer keySerializer;
    private final FileSource fileSource;
    @Nullable
    private final DataFileIndexWriter dataFileIndexWriter;
    private BinaryRow minKey = null;
    private InternalRow maxKey = null;
    private long minSeqNumber = Long.MAX_VALUE;
    private long maxSeqNumber = Long.MIN_VALUE;
    private long deleteRecordCount = 0L;

    public KeyValueDataFileWriter(FileIO fileIO, FileWriterContext context, Path path, Function<KeyValue, InternalRow> converter, RowType keyType, RowType valueType, RowType writeRowType, long schemaId, int level, CoreOptions options, FileSource fileSource, FileIndexOptions fileIndexOptions, boolean isExternalPath) {
        super(fileIO, context, path, converter, writeRowType, options.asyncFileWrite());
        this.keyType = keyType;
        this.valueType = valueType;
        this.schemaId = schemaId;
        this.level = level;
        this.keyStatsConverter = new SimpleStatsConverter(keyType);
        this.isExternalPath = isExternalPath;
        this.valueStatsConverter = new SimpleStatsConverter(valueType, options.statsDenseStore());
        this.keySerializer = new InternalRowSerializer(keyType);
        this.fileSource = fileSource;
        this.dataFileIndexWriter = DataFileIndexWriter.create(fileIO, DataFilePathFactory.dataFileToFileIndexPath(path), valueType, fileIndexOptions);
    }

    @Override
    public void write(KeyValue kv) throws IOException {
        super.write(kv);
        if (this.dataFileIndexWriter != null) {
            this.dataFileIndexWriter.write(kv.value());
        }
        this.updateMinKey(kv);
        this.updateMaxKey(kv);
        this.updateMinSeqNumber(kv);
        this.updateMaxSeqNumber(kv);
        if (kv.valueKind().isRetract()) {
            ++this.deleteRecordCount;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Write to Path " + this.path + " key value " + kv.toString(this.keyType, this.valueType));
        }
    }

    private void updateMinKey(KeyValue kv) {
        if (this.minKey == null) {
            this.minKey = this.keySerializer.toBinaryRow(kv.key()).copy();
        }
    }

    private void updateMaxKey(KeyValue kv) {
        this.maxKey = kv.key();
    }

    private void updateMinSeqNumber(KeyValue kv) {
        this.minSeqNumber = Math.min(this.minSeqNumber, kv.sequenceNumber());
    }

    private void updateMaxSeqNumber(KeyValue kv) {
        this.maxSeqNumber = Math.max(this.maxSeqNumber, kv.sequenceNumber());
    }

    @Override
    @Nullable
    public DataFileMeta result() throws IOException {
        if (this.recordCount() == 0L) {
            return null;
        }
        long fileSize = this.outputBytes;
        Pair<SimpleColStats[], SimpleColStats[]> keyValueStats = this.fetchKeyValueStats(this.fieldStats(fileSize));
        SimpleStats keyStats = this.keyStatsConverter.toBinaryAllMode((SimpleColStats[])keyValueStats.getKey());
        Pair<List<String>, SimpleStats> valueStatsPair = this.valueStatsConverter.toBinary((SimpleColStats[])keyValueStats.getValue());
        DataFileIndexWriter.FileIndexResult indexResult = this.dataFileIndexWriter == null ? DataFileIndexWriter.EMPTY_RESULT : this.dataFileIndexWriter.result();
        String externalPath = this.isExternalPath ? this.path.toString() : null;
        return new DataFileMeta(this.path.getName(), fileSize, this.recordCount(), this.minKey, this.keySerializer.toBinaryRow(this.maxKey).copy(), keyStats, (SimpleStats)valueStatsPair.getValue(), this.minSeqNumber, this.maxSeqNumber, this.schemaId, this.level, indexResult.independentIndexFile() == null ? Collections.emptyList() : Collections.singletonList(indexResult.independentIndexFile()), this.deleteRecordCount, indexResult.embeddedIndexBytes(), this.fileSource, (List)valueStatsPair.getKey(), externalPath);
    }

    abstract Pair<SimpleColStats[], SimpleColStats[]> fetchKeyValueStats(SimpleColStats[] var1);

    @Override
    public void close() throws IOException {
        if (this.dataFileIndexWriter != null) {
            this.dataFileIndexWriter.close();
        }
        super.close();
    }
}

