/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel;

import java.io.Serializable;
import org.eclipse.collections.api.ParallelIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.multimap.bag.UnsortedBagMultimap;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.Batch;
import org.eclipse.collections.impl.lazy.parallel.ParallelDistinctIterable;
import org.eclipse.collections.impl.lazy.parallel.ParallelSelectIterable;
import org.eclipse.collections.impl.lazy.parallel.set.ParallelCollectIterable;
import org.eclipse.collections.impl.lazy.parallel.set.ParallelFlatCollectIterable;
import org.eclipse.collections.impl.multimap.bag.SynchronizedPutHashBagMultimap;

@Beta
public abstract class AbstractParallelIterableImpl<T, B extends Batch<T>>
extends AbstractParallelIterable<T, B> {
    @Override
    protected boolean isOrdered() {
        return false;
    }

    public ParallelUnsortedSetIterable<T> asUnique() {
        return new ParallelDistinctIterable(this);
    }

    public ParallelIterable<T> select(Predicate<? super T> predicate) {
        return new ParallelSelectIterable<T>(this, predicate);
    }

    public <P> ParallelIterable<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    public <S> ParallelIterable<S> selectInstancesOf(Class<S> clazz) {
        return this.select(Predicates.instanceOf(clazz));
    }

    public ParallelIterable<T> reject(Predicate<? super T> predicate) {
        return this.select(Predicates.not(predicate));
    }

    public <P> ParallelIterable<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    public <V> ParallelIterable<V> collect(Function<? super T, ? extends V> function) {
        return new ParallelCollectIterable<T, V>(this, function);
    }

    public <P, V> ParallelIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect(Functions.bind(function, parameter));
    }

    public <V> ParallelIterable<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.select(predicate).collect(function);
    }

    public <V> ParallelIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return new ParallelFlatCollectIterable(this, function);
    }

    public <V> UnsortedBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        SynchronizedPutHashBagMultimap result = SynchronizedPutHashBagMultimap.newMultimap();
        this.forEach((Procedure & Serializable)each -> {
            Object key = function.valueOf(each);
            result.put(key, each);
        });
        return result;
    }

    public <V> UnsortedBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        SynchronizedPutHashBagMultimap result = SynchronizedPutHashBagMultimap.newMultimap();
        this.forEach((Procedure & Serializable)each -> {
            Iterable keys = (Iterable)function.valueOf(each);
            for (Object key : keys) {
                result.put(key, each);
            }
        });
        return result;
    }
}

