/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AllocationActivity;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AllocationState;

public class NodeAllocation {
    private NodeId nodeId;
    private long timeStamp;
    private ContainerId containerId = null;
    private AllocationState containerState = AllocationState.DEFAULT;
    private List<AllocationActivity> allocationOperations;
    private ActivityNode root = null;
    private static final Log LOG = LogFactory.getLog(NodeAllocation.class);

    public NodeAllocation(NodeId nodeId) {
        this.nodeId = nodeId;
        this.allocationOperations = new ArrayList<AllocationActivity>();
    }

    public void addAllocationActivity(String parentName, String childName, String priority, ActivityState state, String diagnostic, String type) {
        AllocationActivity allocate = new AllocationActivity(parentName, childName, priority, state, diagnostic, type);
        this.allocationOperations.add(allocate);
    }

    public void updateContainerState(ContainerId containerId, AllocationState containerState) {
        this.containerId = containerId;
        this.containerState = containerState;
    }

    public void transformToTree() {
        ArrayList<ActivityNode> allocationTree = new ArrayList<ActivityNode>();
        if (this.root == null) {
            Set names = Collections.newSetFromMap(new ConcurrentHashMap());
            ListIterator<AllocationActivity> ite = this.allocationOperations.listIterator(this.allocationOperations.size());
            while (ite.hasPrevious()) {
                String name = ite.previous().getName();
                if (name == null) continue;
                if (!names.contains(name)) {
                    names.add(name);
                    continue;
                }
                ite.remove();
            }
            for (AllocationActivity allocationOperation : this.allocationOperations) {
                ActivityNode node = allocationOperation.createTreeNode();
                String name = node.getName();
                for (int i = allocationTree.size() - 1; i > -1 && ((ActivityNode)allocationTree.get(i)).getParentName().equals(name); --i) {
                    node.addChild((ActivityNode)allocationTree.get(i));
                    allocationTree.remove(i);
                }
                allocationTree.add(node);
            }
            this.root = (ActivityNode)allocationTree.get(0);
        }
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public AllocationState getFinalAllocationState() {
        return this.containerState;
    }

    public String getContainerId() {
        if (this.containerId == null) {
            return null;
        }
        return this.containerId.toString();
    }

    public ActivityNode getRoot() {
        return this.root;
    }

    public String getNodeId() {
        return this.nodeId.toString();
    }
}

