/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.ModelAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelCatalog;

public class RegisterModel
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String model;
    protected final String comment;
    protected final Map<String, String> properties;

    public RegisterModel(CommandContext context, String metalake, String catalog, String schema, String model, String comment, Map<String, String> properties) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.model = model;
        this.comment = comment;
        this.properties = properties;
    }

    @Override
    public void handle() {
        NameIdentifier name = NameIdentifier.of(this.schema, this.model);
        Model registeredModel = null;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            ModelCatalog modelCatalog = client.loadCatalog(this.catalog).asModelCatalog();
            registeredModel = modelCatalog.registerModel(name, this.comment, this.properties);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (ModelAlreadyExistsException err) {
            this.exitWithError("Model already exists.");
        }
        catch (Exception err) {
            this.exitWithError(err.getMessage());
        }
        if (registeredModel != null) {
            this.printInformation("Successful register " + registeredModel.name() + ".");
        } else {
            this.exitWithError("Failed to register model: " + this.model + ".");
        }
    }
}

