/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeDefaultVisitor;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;

public class ReassignFieldId
extends DataTypeDefaultVisitor<DataType> {
    private final AtomicInteger fieldId;

    public ReassignFieldId(AtomicInteger fieldId) {
        this.fieldId = fieldId;
    }

    public static DataType reassign(DataType input, AtomicInteger fieldId) {
        return input.accept(new ReassignFieldId(fieldId));
    }

    @Override
    public DataType visit(ArrayType arrayType) {
        return new ArrayType(arrayType.isNullable(), arrayType.getElementType().accept(this));
    }

    @Override
    public DataType visit(MultisetType multisetType) {
        return new MultisetType(multisetType.isNullable(), multisetType.getElementType().accept(this));
    }

    @Override
    public DataType visit(MapType mapType) {
        return new MapType(mapType.isNullable(), mapType.getKeyType().accept(this), mapType.getValueType().accept(this));
    }

    @Override
    public DataType visit(RowType rowType) {
        RowType.Builder builder = RowType.builder(rowType.isNullable(), this.fieldId);
        rowType.getFields().forEach(f -> builder.field(f.name(), f.type().accept(this), f.description(), f.defaultValue()));
        return builder.build();
    }

    @Override
    protected DataType defaultMethod(DataType dataType) {
        return dataType;
    }
}

