/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.htrace.TimelineAnnotation;
import org.apache.htrace.fasterxml.jackson.core.JsonGenerator;
import org.apache.htrace.fasterxml.jackson.databind.JsonSerializer;
import org.apache.htrace.fasterxml.jackson.databind.SerializerProvider;
import org.apache.htrace.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using=SpanSerializer.class)
public interface Span {
    public void stop();

    public long getStartTimeMillis();

    public long getStopTimeMillis();

    public long getAccumulatedMillis();

    public boolean isRunning();

    public String getDescription();

    public long getSpanId();

    public long getTraceId();

    public Span child(String var1);

    public String toString();

    public long[] getParents();

    public void setParents(long[] var1);

    public void addKVAnnotation(String var1, String var2);

    @Deprecated
    public void addKVAnnotation(byte[] var1, byte[] var2);

    public void addTimelineAnnotation(String var1);

    public Map<String, String> getKVAnnotations();

    public List<TimelineAnnotation> getTimelineAnnotations();

    public String getProcessId();

    public void setProcessId(String var1);

    public String toJson();

    public static class SpanSerializer
    extends JsonSerializer<Span> {
        @Override
        public void serialize(Span span, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            List<TimelineAnnotation> timelineAnnotations;
            String processId;
            jgen.writeStartObject();
            if (span.getTraceId() != 0L) {
                jgen.writeStringField("i", String.format("%016x", span.getTraceId()));
            }
            if (span.getSpanId() != 0L) {
                jgen.writeStringField("s", String.format("%016x", span.getSpanId()));
            }
            if (span.getStartTimeMillis() != 0L) {
                jgen.writeNumberField("b", span.getStartTimeMillis());
            }
            if (span.getStopTimeMillis() != 0L) {
                jgen.writeNumberField("e", span.getStopTimeMillis());
            }
            if (!span.getDescription().isEmpty()) {
                jgen.writeStringField("d", span.getDescription());
            }
            if (!(processId = span.getProcessId()).isEmpty()) {
                jgen.writeStringField("r", processId);
            }
            jgen.writeArrayFieldStart("p");
            for (long parent : span.getParents()) {
                jgen.writeString(String.format("%016x", parent));
            }
            jgen.writeEndArray();
            Map<String, String> traceInfoMap = span.getKVAnnotations();
            if (!traceInfoMap.isEmpty()) {
                jgen.writeObjectFieldStart("n");
                for (Map.Entry<String, String> e : traceInfoMap.entrySet()) {
                    jgen.writeStringField(e.getKey(), e.getValue());
                }
                jgen.writeEndObject();
            }
            if (!(timelineAnnotations = span.getTimelineAnnotations()).isEmpty()) {
                jgen.writeArrayFieldStart("t");
                for (TimelineAnnotation tl : timelineAnnotations) {
                    jgen.writeStartObject();
                    jgen.writeNumberField("t", tl.getTime());
                    jgen.writeStringField("m", tl.getMessage());
                    jgen.writeEndObject();
                }
                jgen.writeEndArray();
            }
            jgen.writeEndObject();
        }
    }
}

