/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.zookeeper.server.ZooKeeperCriticalThread;
import org.apache.zookeeper.server.ZooKeeperServerListener;
import org.apache.zookeeper.server.ZooKeeperThread;
import org.junit.Test;

public class ZooKeeperThreadTest {
    private CountDownLatch runningLatch = new CountDownLatch(1);

    @Test(timeout=30000L)
    public void testUncaughtException() throws Exception {
        MyThread t1 = new MyThread("Test-Thread");
        t1.start();
        Assert.assertTrue((String)"Uncaught exception is not properly handled.", (boolean)this.runningLatch.await(10000L, TimeUnit.MILLISECONDS));
        this.runningLatch = new CountDownLatch(1);
        MyCriticalThread t2 = new MyCriticalThread("Test-Critical-Thread");
        t2.start();
        Assert.assertTrue((String)"Uncaught exception is not properly handled.", (boolean)this.runningLatch.await(10000L, TimeUnit.MILLISECONDS));
    }

    public class MyCriticalThread
    extends ZooKeeperCriticalThread {
        public MyCriticalThread(String threadName) {
            super(threadName, new ZooKeeperServerListener(){

                public void notifyStopping(String threadName, int erroCode) {
                }
            });
        }

        public void run() {
            throw new Error();
        }

        protected void handleException(String thName, Throwable e) {
            ZooKeeperThreadTest.this.runningLatch.countDown();
        }
    }

    public class MyThread
    extends ZooKeeperThread {
        public MyThread(String threadName) {
            super(threadName);
        }

        public void run() {
            throw new Error();
        }

        protected void handleException(String thName, Throwable e) {
            ZooKeeperThreadTest.this.runningLatch.countDown();
        }
    }
}

