/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.radixinverted;

import com.googlecode.concurrenttrees.common.CharSequences;
import com.googlecode.concurrenttrees.common.KeyValuePair;
import com.googlecode.concurrenttrees.common.LazyIterator;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.util.PrettyPrintable;
import com.googlecode.concurrenttrees.radixinverted.InvertedRadixTree;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;

public class ConcurrentInvertedRadixTree<O>
implements InvertedRadixTree<O>,
PrettyPrintable,
Serializable {
    private final ConcurrentInvertedRadixTreeImpl<O> radixTree;

    public ConcurrentInvertedRadixTree(NodeFactory nodeFactory) {
        this.radixTree = new ConcurrentInvertedRadixTreeImpl(nodeFactory);
    }

    @Override
    public O put(CharSequence key, O value) {
        return this.radixTree.put(key, value);
    }

    @Override
    public O putIfAbsent(CharSequence key, O value) {
        return this.radixTree.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(CharSequence key) {
        return this.radixTree.remove(key);
    }

    @Override
    public O getValueForExactKey(CharSequence key) {
        return this.radixTree.getValueForExactKey(key);
    }

    @Override
    public Iterable<CharSequence> getKeysStartingWith(CharSequence prefix) {
        return this.radixTree.getKeysStartingWith(prefix);
    }

    @Override
    public Iterable<O> getValuesForKeysStartingWith(CharSequence prefix) {
        return this.radixTree.getValuesForKeysStartingWith(prefix);
    }

    @Override
    public Iterable<KeyValuePair<O>> getKeyValuePairsForKeysStartingWith(CharSequence prefix) {
        return this.radixTree.getKeyValuePairsForKeysStartingWith(prefix);
    }

    @Override
    public Iterable<CharSequence> getClosestKeys(CharSequence candidate) {
        return this.radixTree.getClosestKeys(candidate);
    }

    @Override
    public Iterable<O> getValuesForClosestKeys(CharSequence candidate) {
        return this.radixTree.getValuesForClosestKeys(candidate);
    }

    @Override
    public Iterable<KeyValuePair<O>> getKeyValuePairsForClosestKeys(CharSequence candidate) {
        return this.radixTree.getKeyValuePairsForClosestKeys(candidate);
    }

    @Override
    public Iterable<CharSequence> getKeysPrefixing(final CharSequence document) {
        return new Iterable<CharSequence>(){

            @Override
            public Iterator<CharSequence> iterator() {
                return new LazyIterator<CharSequence>(){
                    Iterator<KeyValuePair<O>> matchesForCurrentSuffix;
                    {
                        this.matchesForCurrentSuffix = ConcurrentInvertedRadixTree.this.radixTree.scanForKeysAtStartOfInput(document).iterator();
                    }

                    @Override
                    protected CharSequence computeNext() {
                        if (this.matchesForCurrentSuffix.hasNext()) {
                            return this.matchesForCurrentSuffix.next().getKey();
                        }
                        return (CharSequence)this.endOfData();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<O> getValuesForKeysPrefixing(final CharSequence document) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return new LazyIterator<O>(){
                    Iterator<KeyValuePair<O>> matchesForCurrentSuffix;
                    {
                        this.matchesForCurrentSuffix = ConcurrentInvertedRadixTree.this.radixTree.scanForKeysAtStartOfInput(document).iterator();
                    }

                    @Override
                    protected O computeNext() {
                        if (this.matchesForCurrentSuffix.hasNext()) {
                            return this.matchesForCurrentSuffix.next().getValue();
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<KeyValuePair<O>> getKeyValuePairsForKeysPrefixing(final CharSequence document) {
        return new Iterable<KeyValuePair<O>>(){

            @Override
            public Iterator<KeyValuePair<O>> iterator() {
                return new LazyIterator<KeyValuePair<O>>(){
                    Iterator<KeyValuePair<O>> matchesForCurrentSuffix;
                    {
                        this.matchesForCurrentSuffix = ConcurrentInvertedRadixTree.this.radixTree.scanForKeysAtStartOfInput(document).iterator();
                    }

                    @Override
                    protected KeyValuePair<O> computeNext() {
                        if (this.matchesForCurrentSuffix.hasNext()) {
                            return this.matchesForCurrentSuffix.next();
                        }
                        return (KeyValuePair)this.endOfData();
                    }
                };
            }
        };
    }

    @Override
    public CharSequence getLongestKeyPrefixing(CharSequence document) {
        KeyValuePair<O> match = this.radixTree.scanForLongestKeyAtStartOfInput(document);
        return match == null ? null : match.getKey();
    }

    @Override
    public O getValueForLongestKeyPrefixing(CharSequence document) {
        KeyValuePair<O> match = this.radixTree.scanForLongestKeyAtStartOfInput(document);
        return match == null ? null : (O)match.getValue();
    }

    @Override
    public KeyValuePair<O> getKeyValuePairForLongestKeyPrefixing(CharSequence document) {
        return this.radixTree.scanForLongestKeyAtStartOfInput(document);
    }

    @Override
    public Iterable<CharSequence> getKeysContainedIn(final CharSequence document) {
        return new Iterable<CharSequence>(){

            @Override
            public Iterator<CharSequence> iterator() {
                return new LazyIterator<CharSequence>(){
                    Iterator<CharSequence> documentSuffixes;
                    Iterator<KeyValuePair<O>> matchesForCurrentSuffix;
                    {
                        this.documentSuffixes = CharSequences.generateSuffixes(document).iterator();
                        this.matchesForCurrentSuffix = Collections.emptyList().iterator();
                    }

                    @Override
                    protected CharSequence computeNext() {
                        while (!this.matchesForCurrentSuffix.hasNext()) {
                            if (this.documentSuffixes.hasNext()) {
                                CharSequence nextSuffix = this.documentSuffixes.next();
                                this.matchesForCurrentSuffix = ConcurrentInvertedRadixTree.this.radixTree.scanForKeysAtStartOfInput(nextSuffix).iterator();
                                continue;
                            }
                            return (CharSequence)this.endOfData();
                        }
                        return this.matchesForCurrentSuffix.next().getKey();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<O> getValuesForKeysContainedIn(final CharSequence document) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return new LazyIterator<O>(){
                    Iterator<CharSequence> documentSuffixes;
                    Iterator<KeyValuePair<O>> matchesForCurrentSuffix;
                    {
                        this.documentSuffixes = CharSequences.generateSuffixes(document).iterator();
                        this.matchesForCurrentSuffix = Collections.emptyList().iterator();
                    }

                    @Override
                    protected O computeNext() {
                        while (!this.matchesForCurrentSuffix.hasNext()) {
                            if (this.documentSuffixes.hasNext()) {
                                CharSequence nextSuffix = this.documentSuffixes.next();
                                this.matchesForCurrentSuffix = ConcurrentInvertedRadixTree.this.radixTree.scanForKeysAtStartOfInput(nextSuffix).iterator();
                                continue;
                            }
                            return this.endOfData();
                        }
                        return this.matchesForCurrentSuffix.next().getValue();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<KeyValuePair<O>> getKeyValuePairsForKeysContainedIn(final CharSequence document) {
        return new Iterable<KeyValuePair<O>>(){

            @Override
            public Iterator<KeyValuePair<O>> iterator() {
                return new LazyIterator<KeyValuePair<O>>(){
                    Iterator<CharSequence> documentSuffixes;
                    Iterator<KeyValuePair<O>> matchesForCurrentSuffix;
                    {
                        this.documentSuffixes = CharSequences.generateSuffixes(document).iterator();
                        this.matchesForCurrentSuffix = Collections.emptyList().iterator();
                    }

                    @Override
                    protected KeyValuePair<O> computeNext() {
                        while (!this.matchesForCurrentSuffix.hasNext()) {
                            if (this.documentSuffixes.hasNext()) {
                                CharSequence nextSuffix = this.documentSuffixes.next();
                                this.matchesForCurrentSuffix = ConcurrentInvertedRadixTree.this.radixTree.scanForKeysAtStartOfInput(nextSuffix).iterator();
                                continue;
                            }
                            return (KeyValuePair)this.endOfData();
                        }
                        return this.matchesForCurrentSuffix.next();
                    }
                };
            }
        };
    }

    @Override
    public int size() {
        return this.radixTree.size();
    }

    @Override
    public Node getNode() {
        return this.radixTree.getNode();
    }

    static class ConcurrentInvertedRadixTreeImpl<O>
    extends ConcurrentRadixTree<O> {
        public ConcurrentInvertedRadixTreeImpl(NodeFactory nodeFactory) {
            super(nodeFactory);
        }

        protected Iterable<KeyValuePair<O>> scanForKeysAtStartOfInput(final CharSequence input) {
            return new Iterable<KeyValuePair<O>>(){

                @Override
                public Iterator<KeyValuePair<O>> iterator() {
                    return new LazyIterator<KeyValuePair<O>>(){
                        Node currentNode;
                        int charsMatched;
                        final int documentLength;
                        {
                            this.currentNode = ConcurrentInvertedRadixTreeImpl.this.root;
                            this.charsMatched = 0;
                            this.documentLength = input.length();
                        }

                        @Override
                        protected KeyValuePair<O> computeNext() {
                            while (this.charsMatched < this.documentLength) {
                                Node nextNode = this.currentNode.getOutgoingEdge(Character.valueOf(input.charAt(this.charsMatched)));
                                if (nextNode == null) {
                                    return (KeyValuePair)this.endOfData();
                                }
                                this.currentNode = nextNode;
                                CharSequence currentNodeEdgeCharacters = this.currentNode.getIncomingEdge();
                                int numCharsInEdge = currentNodeEdgeCharacters.length();
                                if (numCharsInEdge + this.charsMatched > this.documentLength) {
                                    return (KeyValuePair)this.endOfData();
                                }
                                for (int i = 0; i < numCharsInEdge; ++i) {
                                    if (currentNodeEdgeCharacters.charAt(i) == input.charAt(this.charsMatched + i)) continue;
                                    return (KeyValuePair)this.endOfData();
                                }
                                this.charsMatched += numCharsInEdge;
                                if (this.currentNode.getValue() == null) continue;
                                return new ConcurrentRadixTree.KeyValuePairImpl(CharSequences.toString(input.subSequence(0, this.charsMatched)), this.currentNode.getValue());
                            }
                            return (KeyValuePair)this.endOfData();
                        }
                    };
                }
            };
        }

        protected KeyValuePair<O> scanForLongestKeyAtStartOfInput(CharSequence input) {
            CharSequence currentNodeEdgeCharacters;
            Node nextNode;
            int numCharsInEdge;
            Node currentNode = this.root;
            int documentLength = input.length();
            Node candidateNode = null;
            int candidateCharsMatched = 0;
            block0: for (int charsMatched = 0; charsMatched < documentLength && (nextNode = currentNode.getOutgoingEdge(Character.valueOf(input.charAt(charsMatched)))) != null && (numCharsInEdge = (currentNodeEdgeCharacters = (currentNode = nextNode).getIncomingEdge()).length()) + charsMatched <= documentLength; charsMatched += numCharsInEdge) {
                for (int i = 0; i < numCharsInEdge; ++i) {
                    if (currentNodeEdgeCharacters.charAt(i) != input.charAt(charsMatched + i)) break block0;
                }
                if (currentNode.getValue() == null) continue;
                candidateNode = currentNode;
                candidateCharsMatched = charsMatched;
            }
            return candidateNode == null ? null : new ConcurrentRadixTree.KeyValuePairImpl(CharSequences.toString(input.subSequence(0, candidateCharsMatched)), candidateNode.getValue());
        }
    }
}

