/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.listener.api.event.EventSource;
import org.apache.gravitino.listener.api.event.OperationStatus;
import org.apache.gravitino.listener.api.event.OperationType;

@DeveloperApi
public abstract class BaseEvent {
    private final String user;
    @Nullable
    private final NameIdentifier identifier;
    private final long eventTime;

    protected BaseEvent(String user, NameIdentifier identifier) {
        this.user = user;
        this.identifier = identifier;
        this.eventTime = System.currentTimeMillis();
    }

    public String user() {
        return this.user;
    }

    @Nullable
    public NameIdentifier identifier() {
        return this.identifier;
    }

    public long eventTime() {
        return this.eventTime;
    }

    public OperationType operationType() {
        return OperationType.UNKNOWN;
    }

    public String remoteAddress() {
        return "unknown";
    }

    public EventSource eventSource() {
        return EventSource.GRAVITINO_SERVER;
    }

    public OperationStatus operationStatus() {
        return OperationStatus.UNKNOWN;
    }

    public Map<String, String> customInfo() {
        return ImmutableMap.of();
    }
}

