/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.authentication.kerberos;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.iceberg.common.authentication.kerberos.FetchFileUtils;
import org.apache.gravitino.iceberg.common.authentication.kerberos.KerberosConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosClient.class);
    private final ScheduledThreadPoolExecutor checkTgtExecutor;
    private final Map<String, String> conf;
    private final Configuration hadoopConf;
    private UserGroupInformation loginUser;
    private String realm;

    public KerberosClient(Map<String, String> conf, Configuration hadoopConf) {
        this.conf = conf;
        this.hadoopConf = hadoopConf;
        this.checkTgtExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("check-Iceberg-Hive-tgt-%d").build());
    }

    public String getRealm() {
        return this.realm;
    }

    public void login(String keytabFilePath) throws IOException {
        KerberosConfig kerberosConfig = new KerberosConfig(this.conf);
        String catalogPrincipal = kerberosConfig.getPrincipalName();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)catalogPrincipal), (Object)"The principal can't be blank");
        List principalComponents = Splitter.on((char)'@').splitToList((CharSequence)catalogPrincipal);
        Preconditions.checkArgument((principalComponents.size() == 2 ? 1 : 0) != 0, (Object)"The principal has the wrong format");
        UserGroupInformation.setConfiguration((Configuration)this.hadoopConf);
        UserGroupInformation.loginUserFromKeytab((String)catalogPrincipal, (String)keytabFilePath);
        this.loginUser = UserGroupInformation.getCurrentUser();
        int checkInterval = kerberosConfig.getCheckIntervalSec();
        this.checkTgtExecutor.scheduleAtFixedRate(() -> {
            try {
                this.loginUser.checkTGTAndReloginFromKeytab();
            }
            catch (Exception e) {
                LOG.error("Fail to refresh ugi token: ", (Throwable)e);
            }
        }, checkInterval, checkInterval, TimeUnit.SECONDS);
        this.realm = (String)principalComponents.get(1);
    }

    public File saveKeyTabFileFromUri(Long catalogId) throws IOException {
        KerberosConfig kerberosConfig = new KerberosConfig(this.conf);
        String keyTabUri = kerberosConfig.getKeytab();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)keyTabUri), (Object)"Keytab uri can't be blank");
        Preconditions.checkArgument((!keyTabUri.trim().startsWith("hdfs") ? 1 : 0) != 0, (Object)"Keytab uri doesn't support to use HDFS");
        File keytabsDir = new File("keytabs");
        if (!keytabsDir.exists()) {
            keytabsDir.mkdir();
        }
        File keytabFile = new File(String.format("keytabs/gravitino-lakehouse-iceberg-%s-keytab", catalogId));
        keytabFile.deleteOnExit();
        if (keytabFile.exists() && !keytabFile.delete()) {
            throw new IllegalStateException(String.format("Fail to delete keytab file %s", keytabFile.getAbsolutePath()));
        }
        int fetchKeytabFileTimeout = kerberosConfig.getFetchTimeoutSec();
        FetchFileUtils.fetchFileFromUri(keyTabUri, keytabFile, fetchKeytabFileTimeout, this.hadoopConf);
        return keytabFile;
    }

    @Override
    public void close() throws IOException {
        if (this.checkTgtExecutor != null) {
            this.checkTgtExecutor.shutdownNow();
        }
    }

    public UserGroupInformation getLoginUser() {
        return this.loginUser;
    }
}

