/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.auxiliary;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.auxiliary.GravitinoAuxiliaryService;
import org.apache.gravitino.utils.IsolatedClassLoader;
import org.apache.gravitino.utils.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuxiliaryServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(AuxiliaryServiceManager.class);
    public static final String GRAVITINO_AUX_SERVICE_PREFIX = "gravitino.auxService.";
    public static final String AUX_SERVICE_NAMES = "names";
    public static final String AUX_SERVICE_CLASSPATH = "classpath";
    private static final Splitter splitter = Splitter.on((String)",");
    private static final Joiner DOT = Joiner.on((String)".");
    private Map<String, GravitinoAuxiliaryService> auxServices = new HashMap<String, GravitinoAuxiliaryService>();
    private Map<String, IsolatedClassLoader> auxServiceClassLoaders = new HashMap<String, IsolatedClassLoader>();
    private Exception firstException;

    private Class<? extends GravitinoAuxiliaryService> lookupAuxService(String provider, ClassLoader cl) {
        ServiceLoader<GravitinoAuxiliaryService> loader = ServiceLoader.load(GravitinoAuxiliaryService.class, cl);
        List providers = Streams.stream(loader.iterator()).filter(p -> p.shortName().equalsIgnoreCase(provider)).map(Object::getClass).collect(Collectors.toList());
        if (providers.isEmpty()) {
            throw new IllegalArgumentException("No GravitinoAuxiliaryService found for: " + provider);
        }
        if (providers.size() > 1) {
            throw new IllegalArgumentException("Multiple GravitinoAuxiliaryService found for: " + provider);
        }
        return (Class)Iterables.getOnlyElement(providers);
    }

    @VisibleForTesting
    public GravitinoAuxiliaryService loadAuxService(String auxServiceName, IsolatedClassLoader isolatedClassLoader) throws Exception {
        return isolatedClassLoader.withClassLoader(cl -> {
            try {
                Class<? extends GravitinoAuxiliaryService> providerClz = this.lookupAuxService(auxServiceName, (ClassLoader)cl);
                return providerClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @VisibleForTesting
    public IsolatedClassLoader getIsolatedClassLoader(List<String> classPaths) {
        return IsolatedClassLoader.buildClassLoader(classPaths);
    }

    @VisibleForTesting
    static String getValidPath(String auxServiceName, String pathString) {
        Path newPath;
        Path path = Paths.get(pathString, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return path.toAbsolutePath().toString();
        }
        String gravitinoHome = System.getenv("GRAVITINO_HOME");
        if (!path.isAbsolute() && gravitinoHome != null && Files.exists(newPath = Paths.get(gravitinoHome, pathString), new LinkOption[0])) {
            return newPath.toString();
        }
        throw new IllegalArgumentException(String.format("AuxService:%s, classpath: %s not exists, gravitinoHome:%s", auxServiceName, pathString, gravitinoHome));
    }

    private void registerAuxService(String auxServiceName, Map<String, String> config) {
        String classpath = config.get(AUX_SERVICE_CLASSPATH);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{classpath}), (Object)String.format("AuxService:%s, %s%s.%s is not set in configuration", auxServiceName, "gravitino.", auxServiceName, AUX_SERVICE_CLASSPATH));
        List<String> validPaths = splitter.trimResults().omitEmptyStrings().splitToStream((CharSequence)classpath).map(path -> AuxiliaryServiceManager.getValidPath(auxServiceName, path)).collect(Collectors.toList());
        LOG.info("AuxService name:{}, config:{}, valid classpath:{}", new Object[]{auxServiceName, config, validPaths});
        IsolatedClassLoader isolatedClassLoader = this.getIsolatedClassLoader(validPaths);
        try {
            GravitinoAuxiliaryService gravitinoAuxiliaryService = this.loadAuxService(auxServiceName, isolatedClassLoader);
            this.auxServices.put(auxServiceName, gravitinoAuxiliaryService);
            this.auxServiceClassLoaders.put(auxServiceName, isolatedClassLoader);
        }
        catch (Exception e) {
            LOG.error("Failed to register auxService: {}", (Object)auxServiceName, (Object)e);
            throw new RuntimeException(e);
        }
        LOG.info("AuxService:{} registered successfully", (Object)auxServiceName);
    }

    private void registerAuxServices(Map<String, String> config) {
        String auxServiceNames = config.getOrDefault(AUX_SERVICE_NAMES, "");
        splitter.omitEmptyStrings().trimResults().splitToStream((CharSequence)auxServiceNames).forEach(auxServiceName -> this.registerAuxService((String)auxServiceName, MapUtils.getPrefixMap((Map)config, (String)DOT.join(auxServiceName, (Object)"", new Object[0]))));
    }

    private void doWithClassLoader(String auxServiceName, Consumer<IsolatedClassLoader> func) {
        IsolatedClassLoader classLoader = this.auxServiceClassLoaders.get(auxServiceName);
        try {
            classLoader.withClassLoader(cl -> {
                try {
                    func.accept(classLoader);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void serviceInit(Config gravitinoConfig) {
        Map<String, String> serviceConfigs = AuxiliaryServiceManager.extractAuxiliaryServiceConfigs(gravitinoConfig);
        this.registerAuxServices(serviceConfigs);
        this.auxServices.forEach((auxServiceName, auxService) -> this.doWithClassLoader((String)auxServiceName, cl -> auxService.serviceInit(MapUtils.getPrefixMap((Map)serviceConfigs, (String)DOT.join(auxServiceName, (Object)"", new Object[0])))));
    }

    public void serviceStart() {
        this.auxServices.forEach((auxServiceName, auxService) -> this.doWithClassLoader((String)auxServiceName, cl -> auxService.serviceStart()));
    }

    private void stopQuietly(String auxServiceName, GravitinoAuxiliaryService auxiliaryService) {
        block2: {
            try {
                auxiliaryService.serviceStop();
            }
            catch (Exception e) {
                LOG.warn("AuxService:{} stop failed", (Object)auxServiceName, (Object)e);
                if (this.firstException != null) break block2;
                this.firstException = e;
            }
        }
    }

    public void serviceStop() throws Exception {
        this.auxServices.forEach((auxServiceName, auxService) -> this.doWithClassLoader((String)auxServiceName, cl -> this.stopQuietly((String)auxServiceName, (GravitinoAuxiliaryService)auxService)));
        if (this.firstException != null) {
            throw this.firstException;
        }
    }

    @VisibleForTesting
    static Map<String, String> extractAuxiliaryServiceConfigs(Config config) {
        String auxServiceNames = config.getConfigsWithPrefix(GRAVITINO_AUX_SERVICE_PREFIX).getOrDefault(AUX_SERVICE_NAMES, "");
        HashMap<String, String> serviceConfigs = new HashMap<String, String>();
        serviceConfigs.put(AUX_SERVICE_NAMES, auxServiceNames);
        config.getAllConfig().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("gravitino.auxService.names")).filter(entry -> ((String)entry.getKey()).startsWith(GRAVITINO_AUX_SERVICE_PREFIX)).forEach(entry -> {
            String extractKey = ((String)entry.getKey()).substring(GRAVITINO_AUX_SERVICE_PREFIX.length());
            LOG.warn("The configuration {} is deprecated(still working), please use gravitino.{} instead.", entry.getKey(), (Object)extractKey);
            serviceConfigs.put(extractKey, (String)entry.getValue());
        });
        splitter.omitEmptyStrings().trimResults().splitToStream((CharSequence)auxServiceNames).forEach(name -> config.getAllConfig().forEach((k, v) -> AuxiliaryServiceManager.extractConfig(serviceConfigs, name, k, v)));
        return serviceConfigs;
    }

    private static void extractConfig(Map<String, String> serverConfig, String serverName, String configKey, String configValue) {
        String extractedKey;
        String originValue;
        if (configKey.startsWith(String.format("gravitino.%s.", serverName)) && (originValue = serverConfig.put(extractedKey = configKey.substring("gravitino.".length()), configValue)) != null) {
            LOG.warn("The configuration {}{} is overwritten by {}", new Object[]{GRAVITINO_AUX_SERVICE_PREFIX, extractedKey, configKey});
        }
    }
}

