/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive;

import java.util.Properties;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.hive.client.HiveClient;
import org.apache.gravitino.hive.client.HiveClientFactory;
import org.apache.gravitino.utils.ClientPoolImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveClientPool
extends ClientPoolImpl<HiveClient, GravitinoRuntimeException> {
    private static final Logger LOG = LoggerFactory.getLogger(HiveClientPool.class);
    private final HiveClientFactory clientFactory;

    public HiveClientPool(String name, int poolSize, Properties properties) {
        super(poolSize, GravitinoRuntimeException.class, false);
        this.clientFactory = new HiveClientFactory(properties, name);
    }

    protected HiveClient newClient() {
        try {
            return this.clientFactory.createHiveClient();
        }
        catch (Exception e) {
            LOG.error("Failed to connect to Hive Metastore", (Throwable)e);
            throw new GravitinoRuntimeException((Throwable)e, "Failed to connect to Hive Metastore");
        }
    }

    protected HiveClient reconnect(HiveClient client) {
        LOG.warn("Reconnecting to Hive Metastore");
        return client;
    }

    protected boolean isConnectionException(Exception e) {
        return false;
    }

    protected void close(HiveClient client) {
        LOG.info("Closing Hive Metastore client");
    }
}

