/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.dispatcher;

import java.io.IOException;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.catalog.SchemaDispatcher;
import org.apache.gravitino.catalog.TableDispatcher;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.iceberg.common.utils.IcebergIdentifierUtils;
import org.apache.gravitino.iceberg.service.authorization.IcebergRESTServerContext;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergNamespaceOperationDispatcher;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergOwnershipUtils;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;

public class IcebergNamespaceHookDispatcher
implements IcebergNamespaceOperationDispatcher {
    private final IcebergNamespaceOperationDispatcher dispatcher;
    private final String metalake;

    public IcebergNamespaceHookDispatcher(IcebergNamespaceOperationDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.metalake = IcebergRESTServerContext.getInstance().metalakeName();
    }

    @Override
    public CreateNamespaceResponse createNamespace(IcebergRequestContext context, CreateNamespaceRequest createRequest) {
        CreateNamespaceResponse response = this.dispatcher.createNamespace(context, createRequest);
        this.importSchema(context.catalogName(), createRequest.namespace());
        IcebergOwnershipUtils.setSchemaOwner(this.metalake, context.catalogName(), createRequest.namespace(), context.userName(), GravitinoEnv.getInstance().ownerDispatcher());
        return response;
    }

    @Override
    public UpdateNamespacePropertiesResponse updateNamespace(IcebergRequestContext context, Namespace namespace, UpdateNamespacePropertiesRequest updateRequest) {
        return this.dispatcher.updateNamespace(context, namespace, updateRequest);
    }

    @Override
    public void dropNamespace(IcebergRequestContext context, Namespace namespace) {
        this.dispatcher.dropNamespace(context, namespace);
        EntityStore store = GravitinoEnv.getInstance().entityStore();
        try {
            if (store != null) {
                store.delete(IcebergIdentifierUtils.toGravitinoSchemaIdentifier((String)this.metalake, (String)context.catalogName(), (Namespace)namespace), Entity.EntityType.SCHEMA);
            }
        }
        catch (NoSuchEntityException noSuchEntityException) {
        }
        catch (IOException ioe) {
            throw new RuntimeException("io exception when deleting schema entity", ioe);
        }
    }

    @Override
    public GetNamespaceResponse loadNamespace(IcebergRequestContext context, Namespace namespace) {
        return this.dispatcher.loadNamespace(context, namespace);
    }

    @Override
    public ListNamespacesResponse listNamespaces(IcebergRequestContext context, Namespace parentNamespace) {
        return this.dispatcher.listNamespaces(context, parentNamespace);
    }

    @Override
    public boolean namespaceExists(IcebergRequestContext context, Namespace namespace) {
        return this.dispatcher.namespaceExists(context, namespace);
    }

    @Override
    public LoadTableResponse registerTable(IcebergRequestContext context, Namespace namespace, RegisterTableRequest registerTableRequest) {
        LoadTableResponse response = this.dispatcher.registerTable(context, namespace, registerTableRequest);
        this.importTable(context.catalogName(), namespace, registerTableRequest.name());
        IcebergOwnershipUtils.setTableOwner(this.metalake, context.catalogName(), namespace, registerTableRequest.name(), context.userName(), GravitinoEnv.getInstance().ownerDispatcher());
        return response;
    }

    private void importTable(String catalogName, Namespace namespace, String tableName) {
        TableDispatcher tableDispatcher = GravitinoEnv.getInstance().tableDispatcher();
        if (tableDispatcher != null) {
            tableDispatcher.loadTable(IcebergIdentifierUtils.toGravitinoTableIdentifier((String)this.metalake, (String)catalogName, (TableIdentifier)TableIdentifier.of((Namespace)namespace, (String)tableName)));
        }
    }

    private void importSchema(String catalogName, Namespace namespace) {
        SchemaDispatcher schemaDispatcher = GravitinoEnv.getInstance().schemaDispatcher();
        if (schemaDispatcher != null) {
            schemaDispatcher.loadSchema(IcebergIdentifierUtils.toGravitinoSchemaIdentifier((String)this.metalake, (String)catalogName, (Namespace)namespace));
        }
    }
}

