/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.lancedb.lance.namespace.model.CreateNamespaceRequest;
import com.lancedb.lance.namespace.model.CreateNamespaceResponse;
import com.lancedb.lance.namespace.model.DescribeNamespaceResponse;
import com.lancedb.lance.namespace.model.DropNamespaceRequest;
import com.lancedb.lance.namespace.model.DropNamespaceResponse;
import com.lancedb.lance.namespace.model.ListNamespacesResponse;
import com.lancedb.lance.namespace.model.ListTablesResponse;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.gravitino.lance.common.ops.NamespaceWrapper;
import org.apache.gravitino.lance.service.LanceExceptionMapper;

@Path(value="/v1/namespace")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LanceNamespaceOperations {
    private final NamespaceWrapper lanceNamespace;

    @Inject
    public LanceNamespaceOperations(NamespaceWrapper lanceNamespace) {
        this.lanceNamespace = lanceNamespace;
    }

    @GET
    @Path(value="/{id}/list")
    @Timed(name="list-namespaces.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-namespaces", absolute=true)
    public Response listNamespaces(@PathParam(value="id") String namespaceId, @DefaultValue(value="$") @QueryParam(value="delimiter") String delimiter, @QueryParam(value="page_token") String pageToken, @QueryParam(value="limit") Integer limit) {
        try {
            ListNamespacesResponse response = this.lanceNamespace.asNamespaceOps().listNamespaces(namespaceId, Pattern.quote(delimiter), pageToken, limit);
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(namespaceId, e);
        }
    }

    @POST
    @Path(value="/{id}/describe")
    @Timed(name="describe-namespaces.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="describe-namespaces", absolute=true)
    public Response describeNamespace(@PathParam(value="id") String namespaceId, @DefaultValue(value="$") @QueryParam(value="delimiter") String delimiter) {
        try {
            DescribeNamespaceResponse response = this.lanceNamespace.asNamespaceOps().describeNamespace(namespaceId, Pattern.quote(delimiter));
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(namespaceId, e);
        }
    }

    @POST
    @Path(value="/{id}/create")
    @Timed(name="create-namespaces.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-namespaces", absolute=true)
    public Response createNamespace(@PathParam(value="id") String namespaceId, @DefaultValue(value="$") @QueryParam(value="delimiter") String delimiter, CreateNamespaceRequest request) {
        try {
            CreateNamespaceResponse response = this.lanceNamespace.asNamespaceOps().createNamespace(namespaceId, Pattern.quote(delimiter), request.getMode() == null ? CreateNamespaceRequest.ModeEnum.CREATE : request.getMode(), request.getProperties());
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(namespaceId, e);
        }
    }

    @POST
    @Path(value="/{id}/drop")
    @Timed(name="drop-namespaces.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-namespaces", absolute=true)
    public Response dropNamespace(@PathParam(value="id") String namespaceId, @DefaultValue(value="$") @QueryParam(value="delimiter") String delimiter, DropNamespaceRequest request) {
        try {
            DropNamespaceResponse response = this.lanceNamespace.asNamespaceOps().dropNamespace(namespaceId, Pattern.quote(delimiter), request.getMode() == null ? DropNamespaceRequest.ModeEnum.FAIL : request.getMode(), request.getBehavior() == null ? DropNamespaceRequest.BehaviorEnum.RESTRICT : request.getBehavior());
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(namespaceId, e);
        }
    }

    @POST
    @Path(value="/{id}/exists")
    @Timed(name="namespace-exists.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="namespace-exists", absolute=true)
    public Response namespaceExists(@PathParam(value="id") String namespaceId, @DefaultValue(value="$") @QueryParam(value="delimiter") String delimiter) {
        try {
            this.lanceNamespace.asNamespaceOps().namespaceExists(namespaceId, Pattern.quote(delimiter));
            return Response.ok().build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(namespaceId, e);
        }
    }

    @GET
    @Path(value="{id}/table/list")
    @Timed(name="list-tables.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-tables", absolute=true)
    public Response listTables(@PathParam(value="id") String namespaceId, @DefaultValue(value="$") @QueryParam(value="delimiter") String delimiter, @QueryParam(value="page_token") String pageToken, @QueryParam(value="limit") Integer limit) {
        try {
            ListTablesResponse response = this.lanceNamespace.asNamespaceOps().listTables(namespaceId, delimiter, pageToken, limit);
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            return LanceExceptionMapper.toRESTResponse(namespaceId, e);
        }
    }
}

