/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdfs.server.datanode.metrics.OutlierDetector;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSlowNodeDetector {
    public static final Logger LOG = LoggerFactory.getLogger(TestSlowNodeDetector.class);
    @Rule
    public Timeout testTimeout = new Timeout(300000);
    private static final double LOW_THRESHOLD = 1000.0;
    private static final long MIN_OUTLIER_DETECTION_PEERS = 3L;
    private Map<List<Double>, Pair<Double, Double>> medianTestMatrix = new ImmutableMap.Builder().put((Object)new ImmutableList.Builder().add((Object)9.6502431302).build(), (Object)Pair.of(9.6502431302, 0.0)).put((Object)new ImmutableList.Builder().add((Object)1.72168104625).add((Object)11.7872544459).build(), (Object)Pair.of(6.75446774606, 7.4616095611)).put((Object)new ImmutableList.Builder().add((Object)76.2635686249).add((Object)27.0652018553).add((Object)1.3868476443).add((Object)49.7194624164).add((Object)47.385680883).add((Object)57.8721199173).build(), (Object)Pair.of(48.5525716497, 22.837202532)).put((Object)new ImmutableList.Builder().add((Object)86.0573389581).add((Object)93.2399572424).add((Object)64.9545429122).add((Object)35.8509730085).add((Object)1.6534313654).build(), (Object)Pair.of(64.9545429122, 41.9360180373)).put((Object)new ImmutableList.Builder().add((Object)5.00127007366).add((Object)37.9790589127).add((Object)67.5784746266).build(), (Object)Pair.of(37.9790589127, 43.8841594039)).put((Object)new ImmutableList.Builder().add((Object)1.43442932944).add((Object)70.6769829947).add((Object)37.47579656).add((Object)51.1126141394).add((Object)72.2465914419).add((Object)32.2930549225).add((Object)39.677459781).build(), (Object)Pair.of(39.677459781, 16.9537852208)).put((Object)new ImmutableList.Builder().add((Object)26.7913745214).add((Object)68.9833706658).add((Object)29.3882180746).add((Object)68.3455244453).add((Object)74.9277265022).add((Object)12.1469972942).add((Object)72.5395402683).add((Object)7.87917492506).add((Object)33.3253447774).add((Object)72.2753759125).build(), (Object)Pair.of(50.8354346113, 31.9881230079)).put((Object)new ImmutableList.Builder().add((Object)38.6482290705).add((Object)88.0690746319).add((Object)50.6673611649).add((Object)64.5329814115).add((Object)25.2580979294).add((Object)59.6709630711).add((Object)71.5406993741).add((Object)81.3073035091).add((Object)20.5549547284).build(), (Object)Pair.of(59.6709630711, 31.1683520683)).put((Object)new ImmutableList.Builder().add((Object)87.352734249).add((Object)65.4760359094).add((Object)28.9206803169).add((Object)36.5908574008).add((Object)87.7407653175).add((Object)99.3704511335).add((Object)41.3227434076).add((Object)46.2713494909).add((Object)3.49940920921).build(), (Object)Pair.of(46.2713494909, 28.4729106898)).put((Object)new ImmutableList.Builder().add((Object)95.3251533286).add((Object)27.2777870437).add((Object)43.73477168).build(), (Object)Pair.of(43.73477168, 24.3991619317)).build();
    private Map<Map<String, Double>, Set<String>> outlierTestMatrix = new ImmutableMap.Builder().put((Object)ImmutableMap.of((Object)"n1", (Object)0.0, (Object)"n2", (Object)1001.0), (Object)ImmutableSet.of()).put((Object)ImmutableMap.of((Object)"n1", (Object)1.0, (Object)"n2", (Object)1.0, (Object)"n3", (Object)999.0), (Object)ImmutableSet.of()).put((Object)ImmutableMap.of((Object)"n1", (Object)1.0, (Object)"n2", (Object)1.0, (Object)"n3", (Object)1001.0), (Object)ImmutableSet.of((Object)"n3")).put((Object)ImmutableMap.of((Object)"n1", (Object)1000.1, (Object)"n2", (Object)1000.1, (Object)"n3", (Object)2999.9), (Object)ImmutableSet.of()).put((Object)ImmutableMap.of((Object)"n1", (Object)1000.1, (Object)"n2", (Object)1000.1, (Object)"n3", (Object)3000.4), (Object)ImmutableSet.of((Object)"n3")).put((Object)new ImmutableMap.Builder().put((Object)"n1", (Object)1029.4322).put((Object)"n2", (Object)2647.876).put((Object)"n3", (Object)9194.312).put((Object)"n4", (Object)2.2).put((Object)"n5", (Object)2012.92).put((Object)"n6", (Object)1843.81).put((Object)"n7", (Object)1201.43).put((Object)"n8", (Object)6712.01).put((Object)"n9", (Object)3278.554).put((Object)"n10", (Object)2091.765).put((Object)"n11", (Object)9194.77).build(), (Object)ImmutableSet.of((Object)"n3", (Object)"n11")).put((Object)new ImmutableMap.Builder().put((Object)"n1", (Object)5002.0).put((Object)"n2", (Object)9001.0).put((Object)"n3", (Object)5004.0).put((Object)"n4", (Object)1001.0).put((Object)"n5", (Object)5003.0).put((Object)"n6", (Object)2001.0).put((Object)"n7", (Object)5000.0).put((Object)"n8", (Object)101002.0).put((Object)"n9", (Object)5001.0).put((Object)"n10", (Object)5002.0).put((Object)"n11", (Object)5105.0).put((Object)"n12", (Object)5006.0).build(), (Object)ImmutableSet.of((Object)"n8")).build();
    private OutlierDetector slowNodeDetector;

    @Before
    public void setup() {
        this.slowNodeDetector = new OutlierDetector(3L, 1000L);
        GenericTestUtils.setLogLevel((Logger)OutlierDetector.LOG, (Level)Level.ALL);
    }

    @Test
    public void testOutliersFromTestMatrix() {
        for (Map.Entry<Map<String, Double>, Set<String>> entry : this.outlierTestMatrix.entrySet()) {
            LOG.info("Verifying set {}", entry.getKey());
            Set outliers = this.slowNodeDetector.getOutliers(entry.getKey()).keySet();
            Assert.assertTrue((String)("Running outlier detection on " + entry.getKey() + " was expected to yield set " + entry.getValue() + ", but " + " we got set " + outliers), (boolean)outliers.equals(entry.getValue()));
        }
    }

    @Test
    public void testMediansFromTestMatrix() {
        for (Map.Entry<List<Double>, Pair<Double, Double>> entry : this.medianTestMatrix.entrySet()) {
            ArrayList inputList = new ArrayList(entry.getKey());
            Collections.sort(inputList);
            Double median = OutlierDetector.computeMedian(inputList);
            Double expectedMedian = entry.getValue().getLeft();
            Double errorPercent = Math.abs(median - expectedMedian) * 100.0 / expectedMedian;
            Assert.assertTrue((String)("Set " + inputList + "; Expected median: " + expectedMedian + ", got: " + median), (errorPercent < 0.001 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMadsFromTestMatrix() {
        for (Map.Entry<List<Double>, Pair<Double, Double>> entry : this.medianTestMatrix.entrySet()) {
            ArrayList inputList = new ArrayList(entry.getKey());
            Collections.sort(inputList);
            Double mad = OutlierDetector.computeMad(inputList);
            Double expectedMad = entry.getValue().getRight();
            if (entry.getKey().size() > 1) {
                Double errorPercent = Math.abs(mad - expectedMad) * 100.0 / expectedMad;
                Assert.assertTrue((String)("Set " + entry.getKey() + "; Expected M.A.D.: " + expectedMad + ", got: " + mad), (errorPercent < 0.001 ? 1 : 0) != 0);
                continue;
            }
            Double epsilon = 1.0E-6;
            Assert.assertTrue((String)("Set " + entry.getKey() + "; Expected M.A.D.: " + expectedMad + ", got: " + mad), (mad < epsilon ? 1 : 0) != 0);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMedianOfEmptyList() {
        OutlierDetector.computeMedian(Collections.emptyList());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMadOfEmptyList() {
        OutlierDetector.computeMedian(Collections.emptyList());
    }

    private static class Pair<L, R> {
        private final L l;
        private final R r;

        Pair(L l, R r) {
            this.l = l;
            this.r = r;
        }

        L getLeft() {
            return this.l;
        }

        R getRight() {
            return this.r;
        }

        static <L, R> Pair of(L l, R r) {
            return new Pair<L, R>(l, r);
        }
    }
}

