/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.EncryptionMethod;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JWECryptoParts;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JWEEncrypter;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JWEHeader;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.KeyLengthException;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto.impl.DirectCryptoProvider;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jwk.OctetSequenceKey;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.util.ByteUtils;
import org.apache.hadoop.hbase.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DirectEncrypter
extends DirectCryptoProvider
implements JWEEncrypter {
    public DirectEncrypter(SecretKey key) throws KeyLengthException {
        super(key);
    }

    public DirectEncrypter(byte[] keyBytes) throws KeyLengthException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public DirectEncrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        JWEAlgorithm alg = header.getAlgorithm();
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        EncryptionMethod enc = header.getEncryptionMethod();
        if (enc.cekBitLength() != ByteUtils.safeBitLength(this.getKey().getEncoded())) {
            throw new KeyLengthException(enc.cekBitLength(), enc);
        }
        Base64URL encryptedKey = null;
        return ContentCryptoProvider.encrypt(header, clearText, this.getKey(), encryptedKey, this.getJCAContext());
    }
}

