/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.EntryBuffers;
import org.apache.hadoop.hbase.wal.OutputSink;
import org.apache.hadoop.hbase.wal.RecoveredEditsOutputSink;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hbase.wal.WALStreamReader;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.MapUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class AbstractRecoveredEditsOutputSink
extends OutputSink {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveredEditsOutputSink.class);
    private final WALSplitter walSplitter;
    private final ConcurrentMap<String, Long> regionMaximumEditLogSeqNum = new ConcurrentHashMap<String, Long>();
    private static final int MAX_RENAME_RETRY_COUNT = 5;

    public AbstractRecoveredEditsOutputSink(WALSplitter walSplitter, WALSplitter.PipelineController controller, EntryBuffers entryBuffers, int numWriters) {
        super(controller, entryBuffers, numWriters);
        this.walSplitter = walSplitter;
    }

    protected RecoveredEditsWriter createRecoveredEditsWriter(TableName tableName, byte[] region, long seqId) throws IOException {
        Path regionEditsPath = WALSplitUtil.getRegionSplitEditsPath(tableName, region, seqId, this.walSplitter.getFileBeingSplit().getPath().getName(), this.walSplitter.getTmpDirName(), this.walSplitter.conf, this.getWorkerNameComponent());
        if (this.walSplitter.walFS.exists(regionEditsPath)) {
            LOG.warn("Found old edits file. It could be the result of a previous failed split attempt. Deleting " + regionEditsPath + ", length=" + this.walSplitter.walFS.getFileStatus(regionEditsPath).getLen());
            if (!this.walSplitter.walFS.delete(regionEditsPath, false)) {
                LOG.warn("Failed delete of old {}", (Object)regionEditsPath);
            }
        }
        WALProvider.Writer w = this.walSplitter.createWriter(regionEditsPath);
        String msg = "Creating recovered edits writer path=" + regionEditsPath;
        LOG.info(msg);
        this.updateStatusWithMsg(msg);
        return new RecoveredEditsWriter(region, regionEditsPath, w, seqId);
    }

    private String getWorkerNameComponent() {
        if (this.walSplitter.rsServices == null) {
            return "";
        }
        try {
            return URLEncoder.encode(this.walSplitter.rsServices.getServerName().toShortString().replace(":", ","), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("URLEncoder doesn't support UTF-8", e);
        }
    }

    protected void abortRecoveredEditsWriter(RecoveredEditsWriter editsWriter, List<IOException> thrown) {
        this.closeRecoveredEditsWriter(editsWriter, thrown);
        try {
            this.removeRecoveredEditsFile(editsWriter);
        }
        catch (IOException ioe) {
            String errorMsg = "Failed removing recovered edits file at " + editsWriter.path;
            LOG.error(errorMsg);
            this.updateStatusWithMsg(errorMsg);
        }
    }

    protected Path closeRecoveredEditsWriterAndFinalizeEdits(RecoveredEditsWriter editsWriter, List<IOException> thrown) throws IOException {
        if (!this.closeRecoveredEditsWriter(editsWriter, thrown)) {
            return null;
        }
        if (editsWriter.editsWritten == 0L) {
            this.removeRecoveredEditsFile(editsWriter);
            return null;
        }
        Path dst = WALSplitUtil.getCompletedRecoveredEditsFilePath(editsWriter.path, (Long)this.regionMaximumEditLogSeqNum.get(Bytes.toString(editsWriter.encodedRegionName)));
        try {
            if (this.walSplitter.walFS.exists(editsWriter.path)) {
                boolean retry;
                int retryCount = 0;
                do {
                    retry = false;
                    ++retryCount;
                    if (this.walSplitter.walFS.rename(editsWriter.path, dst)) continue;
                    retry = this.deleteOneWithFewerEntriesToRetry(editsWriter, dst);
                } while (retry && retryCount < 5);
                if (retry) {
                    String errorMsg = "Failed renaming recovered edits " + editsWriter.path + " to " + dst + " in " + 5 + " retries";
                    this.updateStatusWithMsg(errorMsg);
                    throw new IOException(errorMsg);
                }
                String renameEditMsg = "Rename recovered edits " + editsWriter.path + " to " + dst;
                LOG.info(renameEditMsg);
                this.updateStatusWithMsg(renameEditMsg);
            }
        }
        catch (IOException ioe) {
            String errorMsg = "Could not rename recovered edits " + editsWriter.path + " to " + dst;
            LOG.error(errorMsg, (Throwable)ioe);
            this.updateStatusWithMsg(errorMsg);
            thrown.add(ioe);
            return null;
        }
        return dst;
    }

    private boolean closeRecoveredEditsWriter(RecoveredEditsWriter editsWriter, List<IOException> thrown) {
        try {
            editsWriter.writer.close();
        }
        catch (IOException ioe) {
            String errorMsg = "Could not close recovered edits at " + editsWriter.path;
            LOG.error(errorMsg, (Throwable)ioe);
            this.updateStatusWithMsg(errorMsg);
            thrown.add(ioe);
            return false;
        }
        String msg = "Closed recovered edits writer path=" + editsWriter.path + " (wrote " + editsWriter.editsWritten + " edits, skipped " + editsWriter.editsSkipped + " edits in " + editsWriter.nanosSpent / 1000L / 1000L + " ms)";
        LOG.info(msg);
        this.updateStatusWithMsg(msg);
        return true;
    }

    private void removeRecoveredEditsFile(RecoveredEditsWriter editsWriter) throws IOException {
        if (this.walSplitter.walFS.exists(editsWriter.path) && !this.walSplitter.walFS.delete(editsWriter.path, false)) {
            String errorMsg = "Failed deleting empty " + editsWriter.path;
            LOG.warn(errorMsg);
            this.updateStatusWithMsg(errorMsg);
            throw new IOException("Failed deleting empty  " + editsWriter.path);
        }
    }

    @Override
    public boolean keepRegionEvent(WAL.Entry entry) {
        ArrayList<Cell> cells = entry.getEdit().getCells();
        for (Cell cell : cells) {
            if (!WALEdit.isCompactionMarker(cell)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegionMaximumEditLogSeqNum(WAL.Entry entry) {
        ConcurrentMap<String, Long> concurrentMap = this.regionMaximumEditLogSeqNum;
        synchronized (concurrentMap) {
            String regionName = Bytes.toString(entry.getKey().getEncodedRegionName());
            Long currentMaxSeqNum = (Long)this.regionMaximumEditLogSeqNum.get(regionName);
            if (currentMaxSeqNum == null || entry.getKey().getSequenceId() > currentMaxSeqNum) {
                this.regionMaximumEditLogSeqNum.put(regionName, entry.getKey().getSequenceId());
            }
        }
    }

    private boolean deleteOneWithFewerEntriesToRetry(RecoveredEditsWriter editsWriter, Path dst) throws IOException {
        if (!this.walSplitter.walFS.exists(dst)) {
            LOG.info("dst {} doesn't exist, need to retry ", (Object)dst);
            return true;
        }
        if (this.isDstHasFewerEntries(editsWriter, dst)) {
            LOG.warn("Found existing old edits file. It could be the result of a previous failed split attempt or we have duplicated wal entries. Deleting " + dst + ", length=" + this.walSplitter.walFS.getFileStatus(dst).getLen() + " and retry is needed");
            if (!this.walSplitter.walFS.delete(dst, false)) {
                LOG.warn("Failed deleting of old {}", (Object)dst);
                throw new IOException("Failed deleting of old " + dst);
            }
            return true;
        }
        LOG.warn("Found existing old edits file and we have less entries. Deleting " + editsWriter.path + ", length=" + this.walSplitter.walFS.getFileStatus(editsWriter.path).getLen() + " and no retry needed as dst has all edits");
        if (!this.walSplitter.walFS.delete(editsWriter.path, false)) {
            LOG.warn("Failed deleting of {}", (Object)editsWriter.path);
            throw new IOException("Failed deleting of " + editsWriter.path);
        }
        return false;
    }

    private boolean isDstHasFewerEntries(RecoveredEditsWriter editsWriter, Path dst) throws IOException {
        long dstMinLogSeqNum = -1L;
        try (WALStreamReader reader = this.walSplitter.getWalFactory().createStreamReader(this.walSplitter.walFS, dst);){
            WAL.Entry entry = reader.next();
            if (entry != null) {
                dstMinLogSeqNum = entry.getKey().getSequenceId();
            }
        }
        catch (EOFException e) {
            LOG.debug("Got EOF when reading first WAL entry from {}, an empty or broken WAL file?", (Object)dst, (Object)e);
        }
        return editsWriter.minLogSeqNum < dstMinLogSeqNum;
    }

    final class RecoveredEditsWriter {
        long editsWritten = 0L;
        long editsSkipped = 0L;
        long nanosSpent = 0L;
        final byte[] encodedRegionName;
        final Path path;
        final WALProvider.Writer writer;
        final long minLogSeqNum;

        RecoveredEditsWriter(byte[] encodedRegionName, Path path, WALProvider.Writer writer, long minLogSeqNum) {
            this.encodedRegionName = encodedRegionName;
            this.path = path;
            this.writer = writer;
            this.minLogSeqNum = minLogSeqNum;
        }

        private void incrementEdits(int edits) {
            this.editsWritten += (long)edits;
        }

        private void incrementSkippedEdits(int skipped) {
            this.editsSkipped += (long)skipped;
            AbstractRecoveredEditsOutputSink.this.totalSkippedEdits.addAndGet(skipped);
        }

        private void incrementNanoTime(long nanos) {
            this.nanosSpent += nanos;
        }

        void writeRegionEntries(List<WAL.Entry> entries) throws IOException {
            long startTime = System.nanoTime();
            int editsCount = 0;
            for (WAL.Entry logEntry : entries) {
                this.filterCellByStore(logEntry);
                if (!logEntry.getEdit().isEmpty()) {
                    try {
                        this.writer.append(logEntry);
                    }
                    catch (IOException e) {
                        this.logAndThrowWriterAppendFailure(logEntry, e);
                    }
                    AbstractRecoveredEditsOutputSink.this.updateRegionMaximumEditLogSeqNum(logEntry);
                    ++editsCount;
                    continue;
                }
                this.incrementSkippedEdits(1);
            }
            this.incrementEdits(editsCount);
            this.incrementNanoTime(System.nanoTime() - startTime);
        }

        private void logAndThrowWriterAppendFailure(WAL.Entry logEntry, IOException e) throws IOException {
            e = e instanceof RemoteException ? ((RemoteException)((Object)e)).unwrapRemoteException() : e;
            String errorMsg = "Failed to write log entry " + logEntry.toString() + " to log";
            LOG.error(HBaseMarkers.FATAL, errorMsg, (Throwable)e);
            AbstractRecoveredEditsOutputSink.this.updateStatusWithMsg(errorMsg);
            throw e;
        }

        private void filterCellByStore(WAL.Entry logEntry) {
            Map<byte[], Long> maxSeqIdInStores = AbstractRecoveredEditsOutputSink.this.walSplitter.getRegionMaxSeqIdInStores().get(Bytes.toString(logEntry.getKey().getEncodedRegionName()));
            if (MapUtils.isEmpty(maxSeqIdInStores)) {
                return;
            }
            ArrayList<Cell> keptCells = new ArrayList<Cell>(logEntry.getEdit().getCells().size());
            for (Cell cell : logEntry.getEdit().getCells()) {
                if (WALEdit.isMetaEditFamily(cell)) {
                    keptCells.add(cell);
                    continue;
                }
                byte[] family = CellUtil.cloneFamily(cell);
                Long maxSeqId = maxSeqIdInStores.get(family);
                if (maxSeqId != null && maxSeqId >= logEntry.getKey().getSequenceId()) continue;
                keptCells.add(cell);
            }
            logEntry.getEdit().setCells(keptCells);
        }
    }
}

