/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class ClusterIdFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterIdFetcher.class);
    private final List<ServerName> bootstrapServers;
    private final User user;
    private final RpcClient rpcClient;
    private final RpcControllerFactory rpcControllerFactory;
    private final CompletableFuture<String> future;

    ClusterIdFetcher(Configuration conf, User user, RpcControllerFactory rpcControllerFactory, Set<ServerName> bootstrapServers) {
        this.user = user;
        this.rpcClient = RpcClientFactory.createClient(conf, null);
        this.rpcControllerFactory = rpcControllerFactory;
        this.bootstrapServers = new ArrayList<ServerName>(bootstrapServers);
        Collections.shuffle(this.bootstrapServers);
        this.future = new CompletableFuture();
    }

    private void getClusterId(final int index) {
        ServerName server = this.bootstrapServers.get(index);
        LOG.debug("Going to request {} for getting cluster id", (Object)server);
        RpcChannel channel = this.rpcClient.createRpcChannel(server, this.user, 0);
        RegistryProtos.ConnectionRegistryService.Stub stub = RegistryProtos.ConnectionRegistryService.newStub((RpcChannel)channel);
        final HBaseRpcController controller = this.rpcControllerFactory.newController();
        stub.getConnectionRegistry((RpcController)controller, RegistryProtos.GetConnectionRegistryRequest.getDefaultInstance(), (RpcCallback)new RpcCallback<RegistryProtos.GetConnectionRegistryResponse>(){

            public void run(RegistryProtos.GetConnectionRegistryResponse resp) {
                if (!controller.failed()) {
                    LOG.debug("Got connection registry info: {}", (Object)resp);
                    ClusterIdFetcher.this.future.complete(resp.getClusterId());
                    return;
                }
                if (ConnectionUtils.isUnexpectedPreambleHeaderException(controller.getFailed())) {
                    LOG.debug("Failed to get connection registry info, should be an old server, fallback to use null cluster id", (Throwable)controller.getFailed());
                    ClusterIdFetcher.this.future.complete(null);
                } else {
                    LOG.debug("Failed to get connection registry info", (Throwable)controller.getFailed());
                    if (index == ClusterIdFetcher.this.bootstrapServers.size() - 1) {
                        ClusterIdFetcher.this.future.completeExceptionally(controller.getFailed());
                    } else {
                        ClusterIdFetcher.this.getClusterId(index + 1);
                    }
                }
            }
        });
    }

    CompletableFuture<String> fetchClusterId() {
        this.getClusterId(0);
        FutureUtils.addListener(this.future, (r, e) -> this.rpcClient.close());
        return this.future;
    }
}

